% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/class-dtwSat.R
\docType{methods}
\name{dtwSat}
\alias{dtwSat}
\title{Multidimensional Time-Weighted DTW Alignment}
\usage{
dtwSat(query, template, ...)
}
\arguments{
\item{query}{A \link[zoo]{zoo} object with a query time series}

\item{template}{A \link[zoo]{zoo} object with a template time series similar
to \code{query}. The \code{template} must have the same number of attributes
and be equal to or longer than the \code{query}}

\item{...}{additional arguments passed to \code{\link[dtwSat]{twdtw}}}
}
\value{
An object of class \link[dtwSat]{dtwSat-class}
}
\description{
This function performs a multidimensional Time-Weighted DTW
analysis and retrieves one or more possible alignments of a query within
a time series.
}
\examples{
names(query.list)
alig = dtwSat(query.list[["Soybean"]], template)
alig
}
\author{
Victor Maus, \email{vwmaus1@gmail.com}
}
\seealso{
\code{\link[dtwSat]{twdtw}} and \code{\link[dtwSat]{mtwdtw}}
}

