% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R, R/minute.R, R/set.R
\name{dtt_minutes}
\alias{dtt_minutes}
\alias{dtt_minutes<-}
\alias{dtt_minute}
\alias{dtt_minute<-}
\alias{dtt_minute.Date}
\alias{dtt_minute.POSIXct}
\alias{dtt_minute.hms}
\alias{dtt_minute<-.POSIXct}
\alias{dtt_minute<-.hms}
\alias{dtt_set_minute}
\title{Get and Set Minute Values}
\usage{
dtt_minutes(x, ...)

dtt_minutes(x) <- value

dtt_minute(x, ...)

dtt_minute(x) <- value

\method{dtt_minute}{Date}(x, ...)

\method{dtt_minute}{POSIXct}(x, ...)

\method{dtt_minute}{hms}(x, ...)

\method{dtt_minute}{POSIXct}(x) <- value

\method{dtt_minute}{hms}(x) <- value

dtt_set_minute(x, value)
}
\arguments{
\item{x}{A date/time vector.}

\item{...}{Unused.}

\item{value}{A integer vector of the minute value(s).}
}
\value{
An integer vector (or the modified date/time vector).
}
\description{
Gets and sets minute values for date/time vectors.
}
\section{Methods (by class)}{
\itemize{
\item \code{Date}: Get integer vector of minute values for a Date vector

\item \code{POSIXct}: Get integer vector of minute values for a POSIXct vector

\item \code{hms}: Get integer vector of minute values for a hms vector

\item \code{POSIXct}: Set minute values for a POSIXct vector

\item \code{hms}: Set minute values for a hms vector
}}

\examples{
x <- as.POSIXct("1990-01-02 23:40:51")
dtt_minute(x)
dtt_minute(x) <- 27L
x

x <- hms::as_hms("23:40:51")
dtt_minute(x)
dtt_minute(x) <- 27L
x
}
