% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Simulation.R
\docType{class}
\name{Simulation-class}
\alias{Simulation-class}
\title{Class "Simulation"}
\description{
Class \code{"Simulation"} is an S4 class containing descriptions of the
region, population, survey design and analyses the user wishes to investigate.
Once the simulation has been run the N.D.Estimates will contain multiple
estimates of abundance and density obtained by repeatedly generating
populations, simulating the survey and completing the analyses.
}
\section{Slots}{

\describe{
\item{\code{reps}}{Object of class \code{"numeric"}; the number of
times the simulation should be repeated.}

\item{\code{single.transect.set}}{Object of class \code{"logical"}; if
\code{TRUE} the same set of transects are used in each repetition.}

\item{\code{design}}{Object of class \code{"Survey.Design"}; the
survey design.}

\item{\code{population.description}}{Object of class \code{"Population.Description"};
the population.description.}

\item{\code{detectability}}{Object of class \code{"Detectability"}; a
description of the detectability of the population.}

\item{\code{ds.analysis}}{Object of class \code{"DS.Analysis"}}

\item{\code{add.options}}{a list to expand simulation options in the future.}

\item{\code{ddf.param.ests}}{Object of class \code{"array"}; stores the
parameters associated with the detection function.}

\item{\code{results}}{A \code{"list"} with elements 'individuals' (and
optionally 'clusters' and 'expected.size') as well as 'Detection'.

The 'individuals' and 'clusters' elements are a list of three
3-dimensional arrays. The first is a summary array containing
values for 'Area' (strata area), 'CoveredArea' (the area
covered in the strata by the survey), Effort' (the line length
or number of points surveyed), 'n' (the number of sightings),
'n.miss.dists' (the number of missing distances - only applicable
to mixed detector types and not yet implemented in dsims), 'k'
(the number of transects), 'ER' (encounter rate), 'se.ER'
(standard error of the encounter rate), 'cv.ER' (coefficient of
variation of the encounter rate). A value is provided for each
of these for each strata as well as the region as a whole and
for each simulation repetition as well as storing the mean and
standard deviation of these values across simulation repetitions.

The second array 'N' is the abundance estimates table. It contains
values for the 'Estimate' (estimated abundance based on data from
iteration i), 'se' (standard error associated with the estimate),
'cv' (coefficient of variation of estimate), 'lcl' (lower 95\%
confidence interval value), 'ucl' (upper 95\% confidence interval
value), 'df' the degrees of freedom associated with the estimate.
A value is provided for each of these for each strata as well as
the region as a whole and for each simulation repetition as well
as storing the mean and standard deviation of these values across
simulation repetitions.

The third array 'D' is the density estimates table. It contains
values for the 'Estimate' (estimated density based on data from
iteration i), 'se' (standard error associated with the estimate),
'cv' (coefficient of variation of estimate), 'lcl' (lower 95\%
confidence interval value), 'ucl' (upper 95\% confidence interval
value), 'df' the degrees of freedom associated with the estimate.
A value is provided for each of these for each strata as well as
the region as a whole and for each simulation repetition as well
as storing the mean and standard deviation of these values across
simulation repetitions.


When animals occur in clusters the expected.size element of the
results list contains a 3-dimensional array. It gives values
for 'Expected.S' (expected cluster size), 'se.Expected.S'
(the standard error of the expected cluster size),
'cv.Expected.S' (the coefficient of variation for the expected
cluster size). Values are given for each analysis strata as
well as a value for the survey region as a whole and across
each simulation repetition as well as overall means and standard
deviations across repetitions.


The Detection element of the results list is a 3-dimensional
array with values for 'True.Pa' (the proportion of animals in
the covered region which were detected), 'Pa' (the estimated
proportion of animals detected in the covered region), 'ESW'
(the estimated strip width), 'f(0)' (The estimated value of
the detection function pdf at distance 0), 'SelectedModel'
(the index of the model which had the best fit to the dataset
for the repetition), 'DeltaCriteria' (the difference in
information criteria between the best and second best fitting
models where two or more models were fitted and converged),
'SuccessfulModels' (the number of models which successfully
converged). Currently detection functions are pooled across
all strata so there is only one global value for each
simulated dataset as well as a mean value and standard
deviation where appropriate.}

\item{\code{warnings}}{A \code{"list"} to store warnings and error messages encountered
during runtime.}
}}

\section{Methods}{

\describe{
 \item{\code{summary}}{\code{signature=(object = "Simulation")}: produces
 a summary of the simulation and its results.}
 \item{\code{generate.population}}{\code{signature = (object =
 "Simulation")}: generates a single instance of a population.}
 \item{\code{generate.transects}}{\code{signature = (object =
 "Simulation")}: generates a single set of transects.}
 \item{\code{run.survey}}{\code{signature = (object =
 "Simulation")}: carries out the simulation process as far as generating
 the distance data and returns an object containing the population,
 transects and data.}
 \item{\code{run.simulation}}{\code{signature = (simulation = "Simulation")}: runs
 the whole simulation for the specified number of repetitions.}
}
}

\seealso{
\code{\link{make.simulation}}
}
\keyword{classes}
