#   2000/04/18 11:17:14


############################################################

# following is a workaround for ar in ts library

DSE.ar <- function(data, ...) {
  #fix for ar in R ts library (so that univariate case also gives array result)
  if (is.R()) if( !require("ts", warn.conflicts=F)) stop("package ts is required.")
  res <- ar(ts(data), ...)
  if (! is.array(res$ar)) res$ar <- array(res$ar, c(length(res$ar),1,1))
  res
  }

############################################################

#  Utility functions for noise   <<<<<<<<<<

############################################################

print.test.value <- function(x, digits=16)
  {cat("c( ")
   if (all(is.na(x))) cat("NAs")
   else if (is.null(x)) cat("NULL")
   else if (is.logical(x)) cat(x)
   else if (is.S()) print(x, digits=digits)
   else 
     for (i in  1:length(x)) cat(", ", formatC(x[i], digits=digits, format="g"))
   cat(")\n")
   invisible()
  }


get.RNG <- function(e)UseMethod("get.RNG")
get.RNG.default <- function(e=NULL)
  {if (is.null(e)) return(set.RNG())
   if      (!is.null(e$version))  v <- e$version
   else if (!is.null(e$noise))    v <- e$noise$version
   else v <- NULL
   if (is.null(v)) warning("version cannot be verified getting random seed.")
   else if (!all(unlist(version) == unlist(v))) 
     warning("Seed used but version does not correspond to original. Differences may occur.")
  if      (!is.null(e$rng))  k <- e$rng
  else if (!is.null(e$noise)) k <- e$noise$rng
  else stop("RNG info not found.")
  k
 }



make.TSnoise <- function(sampleT,p,lags,noise=NULL, rng=NULL, 
                        SIGMA=NULL, sd=1, noise.model=NULL,
                        noise.baseline=0,
                        tf=NULL, start=NULL,frequency=NULL)
 {# CAUTION: changes here can affect historical comparisons.         
  # noise.baseline is added to noise. It should be either a scalar, a matrix of
  #   the same dimension as noise (or noise generated by noise.model), or a 
  #   vector of length equal to the dimension of the noise process (which will
  #   be replicated for all periods.) 

 if(is.null(rng)) rng <- set.RNG() # returns setting so don't skip if NULL
 else        {old.rng <- set.RNG(rng);  on.exit(set.RNG(old.rng))  }
 
  if ( (!is.null(noise)) & (!is.null(noise.model)) )
    stop("noise and noise.model cannot both be specified.")

  if(!is.null(noise.baseline) && is.matrix(noise.baseline) && 
    (sampleT < dim(noise.baseline)[1]))
      {warning("sampleT (and start date) for noise adjusted to match noise.baseline")
       sampleT <- dim(noise.baseline)[1]
      }

 # Note: noise is added to initial conditions.
 if (!is.null(noise.model))
   {noise <- output.data(simulate(noise.model, sampleT=sampleT+lags))        
    noise <- list(w0=noise[1:lags,,drop=F], w=noise[lags+seq(sampleT),,drop=F])
   }
  if (is.null(noise))
   {w0 <-matrix(NA,lags,p)
    w <- matrix(NA,sampleT,p)
    if (!is.null(SIGMA))
       {if(length(SIGMA) == 1) SIGMA <- diag(SIGMA, p)
	W <- t(chol(SIGMA))
        w <- t(W %*% t(matrix(rnorm((lags+sampleT)*p),(lags+sampleT),p)))
	w0 <- w[1:lags,]
	w  <- w[-c(1:lags),]
       }
    else
      {if (length(sd)==1) sd <-rep(sd,p)
       for (i in 1:p)
         {w0[,i] <- rnorm(lags,sd=sd[i])
          w[,i]  <- rnorm(sampleT,sd=sd[i])
         }
      }
    noise <- list(w=w, w0=w0)
   }

  if(!is.null(noise.baseline))
     {if (is.vector(noise.baseline))
        {if(length(noise.baseline)==1) noise$w <- noise$w + noise.baseline
         else if(length(noise.baseline)==1) 
           noise$w <-noise$w + t(array(noise.baseline, rev(dim(noise$w))))
         else stop("noise.baseline vector is not correct length.")
        }
      else  noise$w <- noise$w + noise.baseline
     }

  if(!is.null(tf)) tframe(noise$w) <- tf
  else if(!is.null(start))
      {if (is.null(frequency))
         {frequency <- 1
          warning("start set but frequency not specified. Using frequency=1.")
         }
       else noise$w <-tframed(noise$w, list(start=start, frequency=frequency))
       if (is.tframed(noise.baseline) && 
           test.equal(tframe(noise.baseline),tframe(noise$w)))
           {warning("tframe of noise set to tframe of noise.baseline.")
            tframe(noise$w )<-tframe(noise.baseline)
            if(!all(dimnames(noise$w)[[2]] == dimnames(noise.baseline)[[2]]))
              warning("noise names and noise.baseline names do not correspond.")
           }
      }
  append(noise, list(sampleT=sampleT, rng=rng, 
     SIGMA=SIGMA, sd=sd, noise.model=noise.model,version=as.vector(version)))
 }

############################################################

#  Model simulation functions (to generate data)   <<<<<<<<<<

############################################################



simulate <- function(model, ...)UseMethod("simulate")

simulate.TSestModel <- function(model, input=input.data(model),
			sd=NULL, SIGMA=NULL, ...)
  {if (is.null(sd) & is.null(SIGMA)) SIGMA <- model$estimates$cov
   simulate(TSmodel(model), input=input, sd=sd, SIGMA=SIGMA, ...)
  }

simulate.SS <- function(model, input=NULL,
                 start. = NULL, freq = NULL,sampleT=100, 
                 noise=NULL, sd=1, SIGMA=NULL, rng=NULL, 
                 compiled=.DSECOMPILED)
{# S function to simulate a state space model:
#
#        z(t) = Fz(t-1) + Gu(t) + Qe(t)
#        y(t) = Hz(t)  + Rw(t)
# 
# or the innovations model:
#        z(t) = Fz(t-1) + Gu(t) + Kw(t-1)
#        y(t) = Hz(t)  + w(t)
#
#  see also the description in l.SS
# input=u must be specified if the matrix model$G is not NULL.
# If noise is NULL then an normal noise will be generated.
# This will be N(0,I) in the  non.innovation case (but Q and R 
# allow for arbitrary noise). If Q is not square (i.e. the system
# noise has a dimension less than the state dimension) then it is
# padded with zeros, so generated noise of higher dimension has no
# effect.  In the innovations case the noise will be N(0,sd^2).
# sd can be a vector of p elements corresponding to each of the p
# outputs.
# If noise is 
# specified it should be a list with elements $w0, $w and $e.
# $w0 is the noise at time zero (a p-vector of w(0) for innovations
# models and an n-vector of e(0) for  non.innovations models).
# If $w0 is a matrix (as for ARMA simulations) then it is set to a
# vector of zeros. This provides compatability with VAR models (ARMA
# models with no lags in B). In general ARMA and SS simulations will
# not produce exactly the same results because it is impossible to
# determine necessary transformation of initial conditions and w0.
# $w should be a sampleT by p matrix giving the output or 
# innovations noise or t=1 to sampleT. 
# For innovations models$e should be NULL.
# For  non.innovations models $e should be a sampleT by n matrix 
# giving the system noise for t=1 to sampleT.
# sampleT will be dim($w)[1] if noise is specified.

if(!is.TSm.or.em(model)) TS.error.exit()
if (is.TSestModel(model)) model <- model$model
if (!is.SS(model)) TS.error.exit(clss="SS")
 
 FF<-    model$F
 G <-    model$G
 H <-    model$H
 m <- dim(G)[2]
 if(is.null(m)) m <-0
 n <- dim(FF)[2]
 p <- dim(H)[1]
 if (m!=0)
   {if( is.null(input)) stop("input series must be supplied for this model.")
    if (sampleT != periods(input) ) input <- truncate(input, end=sampleT)
   }
 if (is.innov.SS(model))
   {K <-    model$K}
 else
   {Q <-    model$Q
    if (ncol(Q)<n) Q <- cbind(Q,matrix(0,n,n-ncol(Q))) # Q assumed square
    R <-    model$R
   }
 
 if(is.null(rng)) rng <- set.RNG() # returns setting so don't skip if NULL
 else        {old.rng <- set.RNG(rng);  on.exit(set.RNG(old.rng))  }
 

set.ts <- T             
if (!is.null(start.))
  {if (!is.null(freq))   tf <- list(start=start., frequency=freq)
   else
      {warning("start. is specified but not freq. Using freq=1.") 
       tf <- list(start=start., frequency=1)
      }
  }  
else if( (!is.null(input))   && is.tframed(input))   tf <- tframe(input)
else if ((!is.null(noise$w)) && is.tframed(noise$w)) tf <- tframe(noise$w)
else set.ts <-  F



# It would be better to use make.TSnoise here (lag=1 and w0<-c(noise$w0) ) and
#  possibly two calls to get e for non-innov models. However, this will affect
#  historical comparisons so it needs to be done carefully!
 e <-NULL
 if (is.null(noise))
   {if (!is.innov.SS(model)) 
      {w0 <- rnorm(n)
       e <- matrix(rnorm(sampleT*n),sampleT,n)
       w <- matrix(rnorm(sampleT*p),sampleT,p)
      }
    else 
      {w <- matrix(NA,sampleT,p)
       w0 <- rep(NA,p)
       if (!is.null(SIGMA))
         {if(length(SIGMA) == 1) SIGMA <- diag(SIGMA, p)
	  W <- t(chol(SIGMA))
	  w.help <- t(W %*% matrix(rnorm((sampleT+1)*p),nrow=p,ncol=sampleT+1))
	  w0 <- w.help[1,]
	  w <- w.help[-1,]
         }
       else
         {if (length(sd)==1) sd <-rep(sd,p)
          for (i in 1:p)
            {w0[i] <- rnorm(1,sd=sd[i])
             w[,i] <- rnorm(sampleT,sd=sd[i])
            }
         }
      }
   }
 else
   {w0 <- noise$w0
    if (is.matrix(w0)) w0 <- rep(0,p) # see note above re VAR
    w<-noise$w
    e<-noise$e
    sampleT<-dim(noise$w)[1]
   }

 y <- matrix(0,sampleT,p)
 state <- matrix(0,sampleT,n)
 if(is.null(model$z0)) z <-rep(0,n) # initial state
 else  z <- model$z0        

 if (is.innov.SS(model)) 
   {z <-  c(FF%*% z) + c(K %*% w0)
    if (m !=0) z <-  z + c(G%*%input[1,]) 
    y[1,]  <-  c(H %*% z) + c(w[1,])
   }   
 else      
   {z <-  c(FF%*% z) + c(Q %*% w0)
    if (m !=0) z <-  z + c(G %*% input[1,])  
    y[1,]  <-  c(H %*% z) + c(R %*% w[1,])
   }
 state[1,]<-z
 # Note: the first period is done above for both compiled and S versions so
 #    that initial conditions do not have to be passed to compiled code.
 if (compiled)
   {if (is.innov.SS(model))
      {Q <-matrix(0,n,n)
       R <-matrix(0,p,p)
       e <- matrix(0,sampleT,n)
      }
    else K <- matrix(0,n,p)
    if (m==0) 
      {input <- matrix(0,sampleT,1)
       G <- matrix(0,n,1)
      }
    storage.mode(y)     <- "double"
    storage.mode(state) <- "double"
    r<- .Fortran("simss",y=y, 
                         state=state, 
                         as.integer(m),
                         as.integer(n),
                         as.integer(p), 
                         as.integer(sampleT),  
                         as.double(input),
                         as.double(w),
                         as.double(e),
                         as.double(FF),
                         as.double(G),   
                         as.double(H),
                         as.double(K), 
                         as.double(Q),      
                         as.double(R),    
                         as.logical(is.innov.SS(model)))[c("y","state")]
    y <- r$y
    state <- r$state
    if (m==0) input <- NULL
   }
 else
   {for (Time in 2:sampleT)  
      {z <-  c(FF%*% z) 
       if (m !=0) z <-  z + c(G%*%input[Time,]) 
       if (is.innov.SS(model))  z <-  z + c(K%*%w[Time-1,])
       else       z <-  z + c(Q%*%e[Time-1,])
       state[Time,] <- z
       if (is.innov.SS(model)) y[Time,]  <-  c(H %*% z) + c(w[Time,])   
       else      y[Time,]  <-  c(H %*% z) + c(R %*% w[Time,])
   }  }
 if (set.ts)
   { y     <- tframed(y,     tf=tf, names=output.series.names(model)) 
     state <- tframed(state, tf=tf )
   }
 else  series.names(y) <- output.series.names(model)
 TSdata(list(input=input,output=y, state=state, version=version, 
   model=model, description="data generated by simulate.ss",
   noise=list(w0=w0,w=w, e=e, rng=rng, SIGMA=SIGMA, sd=sd)))
}

simulate.ARMA <- function(model, y0=NULL, input=NULL, input0=NULL,
                start. = NULL, freq = NULL, sampleT=100,
                noise=NULL, sd=1, SIGMA=NULL,
                rng=NULL, noise.model=NULL, 
                compiled=.DSECOMPILED)
{# S function to simulate ARMA mode:
#
#       A(L)y(t) =  B(L)w(t) + C(L)u(t) + TREND
# 
# See also the description in ARMA.s
# input=u must be specified if the matrix model$C is not NULL.
# The rng will be set first if it is specified. If noise is 
# specified it should be a list with elements $w0 and $w.
# $w0 is the noise(w) prior to time=1 (a (dim($B)[1]-1) by p matrix).
# For VAR models B has no lags so w0 has no effect.
# $w should be a sampleT by p matrix giving the 
# noise for t=1 to sampleT. 
# sampleT will be dim($w)[1] if noise is specified.


if(!is.TSm.or.em(model)) TS.error.exit()
if (is.TSestModel(model)) model <- model$model
if (!is.ARMA(model)) TS.error.exit(clss="ARMA")
 
A<-    model$A
B <-    model$B
C <-    model$C
TREND <- model$TREND
m <- dim(C)[3]
if (is.null(m)) m <-0
p <- dim(A)[2]
a <-dim(A)[1]
b <-dim(B)[1]
if (is.null(C)) cc <- 0
else            cc<-dim(C)[1]
if ( (p != dim(A)[3])
    |(p != dim(B)[2])
    |(p != dim(B)[3])) 
      stop("dimension of model parameters do not conform!")
if (0 !=m) if (p != dim(C)[2]) 
      stop("dimension of model parameters do not conform!")
if (m!=0)
   {if( is.null(input)) stop("input series must be supplied for this model.")
    if (sampleT != periods(input) ) input <- truncate(input, end=sampleT)
   }
 
if (p==1) invA0 <- matrix(1/A[1,,],1,1)
else      invA0 <- solve(A[1,,])
for (l in 1:a) A[l,,] <- invA0 %*% A[l,,]      # set A(0) = I      
for (l in 1:b) B[l,,] <- invA0 %*% B[l,,] 
if (m!=0) for (l in 1:dim(C)[1]) C[l,,] <- invA0 %*% C[l,,]  
if(!is.null(TREND)) TREND <- invA0 %*% TREND

set.ts <- T             
if (!is.null(start.))
  {if (!is.null(freq))   tf <- list(start=start., frequency=freq)
   else
      {warning("start. is specified but not freq. Using freq=1.") 
       tf <- list(start=start., frequency=1)
      }
  }  
else if( (!is.null(input))   && is.tframed(input))   tf <- tframe(input)
else if ((!is.null(noise$w)) && is.tframed(noise$w)) tf <- tframe(noise$w)
else set.ts <-  F

noise <- make.TSnoise(sampleT,p,b, noise=noise, rng=rng,
                        SIGMA=SIGMA, sd=sd, noise.model=noise.model,
                        start=start., frequency=freq)
if (is.null(sampleT)) sampleT<-noise$sampleT
 
 if(is.null(y0)) y0<-matrix(0,a,p)
 if((m!=0) & is.null(input0)) input0 <- matrix(0,dim(C)[1],m)
 y <- matrix(0,sampleT,p)  
 if (compiled)
   {if (m==0) 
      {input <- matrix(0,sampleT,1)
       input0 <- matrix(0,1,1)
       C <- matrix(0,1,1)
      }
    if (is.null(TREND)) TREND<- rep(0,p)
#    yo<- list(y=y, y0,m,p, a, b, cc, sampleT,input,input0,w,w0,A,B, C,TREND)
    storage.mode(y)     <- "double"
#    prior.args<- list(y=y, 
#                         as.double(y0),
#                         as.integer(m),
#                         as.integer(p), 
#                         as.integer(a), 
#                         as.integer(b), 
#                         as.integer(cc), 
#                         as.integer(sampleT),  
#                         as.double(input[1:sampleT,]),
#                         as.double(input0),
#                         as.double(noise$w),
#                         as.double(noise$w0),
#                         as.double(A),
#                         as.double(B),   
#                         as.double(C),
#                         as.double(TREND))  # [["y"]]
    post.args <-.Fortran("simrma",y=y, 
                         as.double(y0),
                         as.integer(m),
                         as.integer(p), 
                         as.integer(a), 
                         as.integer(b), 
                         as.integer(cc), 
                         as.integer(sampleT),  
                         as.double(input[1:sampleT,]),
                         as.double(input0),
                         as.double(noise$w),
                         as.double(noise$w0),
                         as.double(A),
                         as.double(B),   
                         as.double(C),
                         as.double(TREND))  # [["y"]]

#    if (any(is.na(y$y))) browser()
    y <- post.args[["y"]]
    if (m==0) 
      {input  <- NULL
       input0 <- NULL
      }
   }
 else
  {w0 <- noise$w0
   w<-noise$w
   for (Time in 1:sampleT)  
   {if(!is.null(TREND)) y[Time,] <- TREND # + y[Time,] 
    for (l in 2:a) 
       if(Time+1-l<=0)
          if (p==1) y[Time,] <- y[Time,]-c(A[l,,]  *  y0[l-Time,]) 
          else      y[Time,] <- y[Time,]-c(A[l,,] %*% y0[l-Time,])
       else                
          if (p==1) y[Time,] <- y[Time,]-c(A[l,,]  *  y[Time+1-l,])
          else      y[Time,] <- y[Time,]-c(A[l,,] %*% y[Time+1-l,])
    for (l in 1:b) 
       if (Time+1-l<=0)
          if (p==1) y[Time,]<- y[Time,] +c(B[l,,]  *  w0[l-Time,]) 
          else      y[Time,]<- y[Time,] +c(B[l,,] %*% w0[l-Time,])
       else
          if (p==1) y[Time,]<- y[Time,] +c(B[l,,]  *  w[Time+1-l,])
          else      y[Time,]<- y[Time,] +c(B[l,,] %*% w[Time+1-l,])
    if (m!=0) for (l in 1:cc) 
       if (Time+1-l<=0)
          if (m==1) y[Time,]<- y[Time,] + c(C[l,,]  *  input0[l-Time,])
          else      y[Time,]<- y[Time,] + c(C[l,,] %*% input0[l-Time,])
       else
          if (m==1) y[Time,]<-y[Time,] + c(C[l,,]  *  input[Time+1-l,])
          else      y[Time,]<-y[Time,] + c(C[l,,] %*% input[Time+1-l,])
  }}
 if (set.ts) y <- tframed(y, tf=tf, names=output.series.names(model)) 
 else series.names(y) <- output.series.names(model)
 TSdata(list(input=input,output=y, 
          model=model, input0=input0, 
          description="data generated by simulate.ARMA", 
#          prior.args=prior.args, post.args=post.args,
          noise=noise))
}

#######################################################################

#functions which work on data (and models)  <<<<<<<<<<

############################################################

#     likelihood and residual calculation functions  <<<<<<<<<<

############################################################


#  L <- function(residual)
#  { # negative log likelihood of a residual
#    sampleT <-nrow(residual)
#    p <- ncol(residual)
#  #  Om <- var(residual)  # var removes mean and /sampleT-1
#    Om <-t(residual) %*% residual /sampleT
#    v <- svd(Om) #eigenvalues are not robust to degenerate density.
#    # next seem a hard way to get det
#  # like1 <- 0.5 * sampleT * log(prod(v$d[v$d!=0]))
#    like1 <- 0.5 * sampleT * log(prod(
#                 v$d[v$d > (v$d[1]*sqrt(.Machine$double.eps))]))
#  # svd is more robust than solve(Om) for degenerate densities
#  #  if (1 == length(v$d)) OmInv <-  v$v %*% (1/v$d) %*%t(v$u) 
#  #  else OmInv <-  v$v %*% diag(1/v$d) %*%t(v$u) 
#  #  OmInv <-  v$v %*% (t(v$u) * 1/v$d) is faster and equivalent but relies on 
#  #  recycling of d and columnwise storage, which work in S and R but are "tricks"
#  # A better way is (but should account for degenerate space as in like1 above)
#    OmInv <-  v$v %*% sweep(t(v$u),1,1/v$d, "*") 
#  #  like2 <- sum(diag(residual %*%OmInv %*% t(residual))) /2
#    like2 <- sum(residual * (residual %*% OmInv)) /2
#    const <- (sampleT * p * log(2 * pi))/2
#    c(const+like1+like2, const, like1,like2)
#  }

residual.stats <- function(pred, data, sampleT=nrow(pred), warn=T)
{  # pred and data should be matrices (model prediction and output data).
   # sampleT allows for the possibility that a sub-sample of data 
   #   was used for estimation.
   # (note predictT can be determined from nrow(pred) and is not used.)
   e <- if (is.null(pred))     -data[1:sampleT,,drop=F]
        else if (is.null(data)) pred[1:sampleT,,drop=F]
        else               pred[1:sampleT,,drop=F] - data[1:sampleT,,drop=F]
   p <- ncol(e)
   Om <-t(e) %*% e /sampleT
   if (any(is.na(Om))) {like1 <- like2 <- 1e100}  
   else if (any(Om >1e100)) {like1 <- like2 <- 1e100}  
   else
     {v <- svd(Om) #eigenvalues are not robust to degenerate density.
#     i <- v$d!=0
     i <- v$d > (v$d[1]*sqrt(.Machine$double.eps))
      if (!all(i))
        {if(warn) warning("The cov. matrix is singular. Working on subspace.")
         v$d <- v$d[i]
         v$u <- v$u[i,i, drop=F]
         v$v <- v$v[i,i, drop=F]
         e <- e[,i, drop=F]
        }
      like1 <- 0.5 * sampleT * log(prod(v$d)) # det
#      if (1 == length(v$d)) OmInv <-  v$v %*% (1/v$d) %*%t(v$u) 
#      else OmInv <-  v$v %*% diag(1/v$d) %*%t(v$u) # more robust than solve(Om)
#  following is equivalent
#      OmInv <-  v$v %*% sweep(t(v$u),1,1/v$d, "*") 
#      like2 <- sum(e * (e %*% OmInv)) /2
#  but this works out to (sampleT*p/2) and fixing for degenerate distributions:
       like2 <- (sampleT*length(v$d))/2
     }
   const <- (sampleT * p * log(2 * pi))/2
   invisible(list(like=c(const+like1+like2, const, like1,like2),
                  cov =Om, pred=pred, sampleT=sampleT))
}



sum.sqerror <- function(parms, model=NULL, data=NULL, error.weights=NULL) 
{ #  this returns only the sum of the weighted squared errors (eg.for optimization).
#  If model, data or error.weights are not supplied the program looks for
#    a global variable named Obj.Func.ARGS with corresponding elements.
#  The sample size is determined by output.periods(data).
 if ( is.null(model)) stop("model missing") # model <- Obj.Func.ARGS$model
 if ( is.null(data))  stop("data missing") # data  <- Obj.Func.ARGS$data
 if ( is.null(error.weights)) stop("error.weights missing") #error.weights <- Obj.Func.ARGS$error.weights 
 sum(l(set.arrays(model,parms=parms), data,
       result="weighted.sqerror",error.weights=error.weights))
}




l <- function(obj1, obj2, ...)UseMethod("l")
l.TSdata <- function(data, model,...) {l(model, data, ...) }
l.TSestModel <- function(model, data,...) {l(model$model,data, ...)}


l.ARMA <- function(model, dat, sampleT=NULL, predictT=NULL,result=NULL,
                error.weights=0,  compiled=.DSECOMPILED, warn=T, return.debug.info=F)
{#  calculate likelihood, residuals, prediction, etc. for ARMA model
 # N.B.  The compiled version is much preferred for speed.
 #  sampleT is the length of data which should be used for 
 #  calculate the one-step ahead predictions, and likelihood value for the model:
#
#       A(L)y(t) =  B(L)w(t) + C(L)u(t) + TREND
# 
# A(L) (axpxp) is the auto-regressive polynomial array.
# B(L) (bxpxp) is the moving-average polynomial array.
# C(L) (cxpxm) is the  input polynomial array.
# TREND is a constant vector added at each period.
# y is the p dimensional output data.
# u is the m dimensional control (input) data.
# Om is the estimated output cov matrix.

if(!is.TSm.or.em(model)) TS.error.exit()
if (is.TSestModel(model)) model <- model$model
if (!is.ARMA(model)) TS.error.exit(clss="ARMA")
 
dat <- freeze(dat)
if(!check.consistent.dimensions(model,dat)) stop("dimension error")
if (is.null(sampleT))  sampleT  <- output.periods(dat)
if (is.null(predictT)) predictT <- sampleT
if (sampleT > predictT) stop("sampleT cannot exceed predictT.")
if (sampleT > output.periods(dat)) stop("sampleT cannot exceed length of data.")
if (0 != input.dimension(dat))
  {if (input.periods(dat) < predictT)
      stop("input data must be at least as long as requested prediction.")
   if (any(is.na(input.data(dat)))) stop("input data cannot contain NAs.")
  }
if (any(is.na(output.data(dat)))) stop("output data cannot contain NAs.")

u <- input.data(dat)
y <- output.data(dat)
A<-    model$A
B <-   model$B
C <-   model$C
TREND <- model$TREND
m <- dim(C)[3]
if (is.null(m)) m <-0
p <- dim(A)[2]
a <-dim(A)[1]
b <-dim(B)[1]
if ( (p != dim(A)[3])
    |(p != dim(B)[2])
    |(p != dim(B)[3])) 
      stop("dimension of model parameters do not conform!")
if (0 !=m) if (p != dim(C)[2]) 
      stop("dimension of model parameters do not conform!")
if (p != output.dimension(dat))
      stop("dimension of model parameters do not conform with the data!")
if (m == 0) 
   {if(!is.null(u)) 
      stop("model parameters indicate an no input but input data exists!")
   }
else if (m != dim(u)[2])  
      stop("dimension of model parameters do not conform with the data!")
if (compiled)
  {if (m==0)
     {C <- array(0,c(1,p,1))    # can't pass 0 length array to compiled
      u <- matrix(0,predictT,1)
     }
   if (is.null(model$TREND)) TREND <- rep(0,p)
   is  <- max(m,p)
   r  <- .Fortran("arma",
                         pred=matrix(1e20,predictT,p), # pred,     
                         as.integer(length(error.weights)),
                         weighted.sqerror=matrix(0,sampleT,p),
                         error.weights= as.double(error.weights),
                         as.integer( m), 
                         as.integer( p) ,      
                         as.integer( dim(A)[1]),  # 1+order of A  
                         as.integer( dim(B)[1]),  # 1+order of B  
                         as.integer( dim(C)[1]),  # 1+order of C  
                         sampleT=as.integer(sampleT),
                         predictT=as.integer(predictT),
                         as.integer(output.periods(dat)), 
                         as.double(u), # as.double() works ok with compiled but
                                    #messes up the dim(u) returned in the list
                         as.double(y),         
                         as.double(A),  
                         as.double(B),   
                         as.double(C),
                         as.double(TREND),
                         as.integer(is),  # scratch array dim
                         as.double(matrix(0,is,is)),  # scratch array
                         as.double(matrix(0,is,is)),  # scratch array
                         as.double(rep(0,is))         # scratch array
                  ) [c("pred", "weighted.sqerror")]
   if (all(0==error.weights)) r$weighted.sqerror <- NULL
  }
else   # start S version
  {prederror <- matrix(0,sampleT,p)  
   wt.err <- NULL
   invB0 <- solve(B[1,,])
   for (l in 1:a) A[l,,] <- invB0 %*% A[l,,]      # set B(0) = I      
   for (l in 1:b) B[l,,] <- invB0 %*% B[l,,]  
   if (m!=0) for (l in 1:dim(C)[1]) C[l,,] <- invB0 %*% C[l,,]  
   if(!is.null(TREND)) TREND <- invB0 %*% TREND
   if (1 < length(error.weights)) wt.err <- matrix(0,predictT,p)    
   for (Time in 1:sampleT)  
      {if(!is.null(TREND)) vt <- -TREND
       else vt    <-  rep(0,p) 
       for (l in 1:a)
          if (l<=Time)  #this is cumbersome but drop=F leaves A,B,C as 3 dim arrays
              if (p==1) vt <- vt + c(A[l,,]  *  y[Time+1-l,])
              else      vt <- vt + c(A[l,,] %*% y[Time+1-l,])  
       if (b >= 2) for (l in 2:b) 
          if (l<=Time) 
             if (p==1) vt <- vt - c(B[l,,]  *  prederror[Time+1-l,]) 
             else      vt <- vt - c(B[l,,] %*% prederror[Time+1-l,])
       if (m!=0) for (l in 1:dim(C)[1]) 
          if (l<=Time) 
             if (m==1) vt <- vt - c(C[l,,]  *  u[Time+1-l,])
             else      vt <- vt - c(C[l,,] %*% u[Time+1-l,])  
       prederror[Time,] <- vt #this is not really the pred error unless B0=I   

       if (any(0!=error.weights))          
        {wt.err[Time,] <- error.weights[1]*vt^2  # weighted sq prediction error
         if (length(error.weights)>1)
           {for (h in 2:length(error.weights))
            if ( (Time+h-1) <= sampleT)
              {if(!is.null(TREND)) vt <- -TREND
               else vt    <-  rep(0,p) 
               for (l in 1:a)
                  if (l < Time+h) 
                     if (p==1) vt <- vt + c(A[l,,]  *  y[Time+h-l,])
                     else      vt <- vt + c(A[l,,] %*% y[Time+h-l,])  
               if (b >= 2) for (l in 2:b) 
                  if (l < Time+h) 
                     if (p==1) vt <- vt - c(B[l,,]  *  prederror[Time+h-l,]) 
                     else      vt <- vt - c(B[l,,] %*% prederror[Time+h-l,])
               if (m!=0) for (l in 1:dim(C)[1]) 
                   if (l < Time+h) 
                      if (m==1) vt <- vt - c(C[l,,]  *  u[Time+h-l,])
                      else      vt <- vt - c(C[l,,] %*% u[Time+h-l,]) 
               wt.err[Time,] <- wt.err[Time,] + error.weights[h]*(solve(invB0 )%*%vt)^2
     }  }  }
  }

   pred <- matrix(0,predictT,p)
   pred[1:sampleT,] <- y[1:sampleT,,drop=F] - prederror[1:sampleT,,drop=F] %*% t(solve(invB0)) 
   # now multi-step predictions to predictT
   if (predictT > sampleT)
    {for (Time in (sampleT+1):predictT)  
      {invA0 <- solve(A[1,,])
       for (l in 1:a) A[l,,] <- invA0 %*% A[l,,]      # set A(0) = I      
       for (l in 1:b) B[l,,] <- invA0 %*% B[l,,]  
       if (m!=0) for (l in 1:dim(C)[1]) C[l,,] <- invA0 %*% C[l,,]  
       if(!is.null(TREND)) TREND <- invA0 %*% TREND
       if(!is.null(TREND)) pred[Time,] <- pred[Time,]+TREND
       for (l in 2:a) 
          if(Time+1-l<=sampleT)
             if (p==1) pred[Time,] <- pred[Time,]-c(A[l,,]  *  y[Time+1-l,]) 
             else      pred[Time,] <- pred[Time,]-c(A[l,,] %*% y[Time+1-l,])
          else                
             if (p==1) pred[Time,] <- pred[Time,]-c(A[l,,]  *  pred[Time+1-l,])
             else      pred[Time,] <- pred[Time,]-c(A[l,,] %*% pred[Time+1-l,])
       if (b >= 2) for (l in 2:b) 
          if (Time+1-l<=sampleT)
             if (p==1)  pred[Time,] <- pred[Time,] +c(B[l,,]  *  prederror[Time+1-l,]) 
             else       pred[Time,] <- pred[Time,] +c(B[l,,] %*% prederror[Time+1-l,])
       if (m!=0) for (l in 1:dim(C)[1]) 
          if (m==1) pred[Time,] <- pred[Time,] + c(C[l,,]  *  u[Time+1-l,]) 
          else      pred[Time,] <- pred[Time,] + c(C[l,,] %*% u[Time+1-l,])
      }
    }
   r<-list(pred=pred,   weighted.sqerror=wt.err)
  } # end of S version

tf <- truncate.tframe(tframe(output.data(dat)), end=predictT)
tframe(r$pred) <- tf
if (! is.null(r$weighted.sqerror))  tframe(r$weighted.sqerror) <- tf
if((!is.null(result)) && (result == "pred")) return(r$pred)
r <- append(residual.stats(r$pred, y, sampleT, warn=warn), 
        list(error.weights=error.weights, weighted.sqerror=r$weighted.sqerror))

if (return.debug.info) 
    r$debug.info <-list(m=m, p=p, a=a,b=b,c=c, A=A,B=B,C=C,TREND=TREND, 
          u=u, y=y,
          prederror=prederror, pred=pred, invB0=invB0, wt.err=wt.err, 
          error.weights=error.weights, sampleT=sampleT)

if ( is.null(result)) return(classed( # TSestModel constructor (l.ARMA)
              list(estimates=r, data=dat, model=model), "TSestModel"))
else 
   {if (result =="like") return(r$like[1]) # neg.log.like. from residual.stats
    else { return(r[[result]]) }
   }
stop("should never get to here in l.ARMA.")
}                       


l.SS <- function(model, data, sampleT=NULL, predictT=NULL, error.weights=0,
                 return.state=F, return.track=F, result=NULL, compiled=.DSECOMPILED,
                 warn=T, return.debug.info=F)
{# ref. B.D.O.Anderson & J.B.Moore "Optimal Filtering" p.39,44.
# sampleT is the length of data which should be used for calculating
# one step ahead predictions. y must be at least as
#  long as sampleT. If predictT is large than sampleT then the model is simulated to 
# predictT. y is used if it is long enough. u must be at least as long as predictT.
# The default result=0 returns a list of all the results. Otherwise only the 
#    indicated list element is return (eg. result=1 return the likelihood and
#    result=3 returns the one step ahead predictions.
#   Calculate the state, residuals, and likelihood value for the model:
#
#        z(t) = Fz(t-1) + Gu(t) + Qe(t)
#        y(t) = Hz(t)  + Rw(t)
# 
# or the innovations model:
#        z(t) = Fz(t-1) + Gu(t) + Kw(t-1)
#        y(t) = Hz(t)  + w(t)
#
# FF (nxn) is the state transition matrix F.
# H (pxn)is the output matrix H.
# Q (nxn) is the input matrix of the system noise and the noise is assumed to be white. 
#    Some authors (eg. Harvey) modify this as rt*qt*rt' where rt is the matrix for the 
#    system noise and qt is the noise cov, but that is redundant.
# R (pxp) is the input matrix of the output (measurement) noise, which is assumed white. 
#      probably need R if p>n ??
# G (nxp)is the control (input) matrix.
# K (nxp)is the Kalman gain.
# y is the p dimensional output data.
# u is the m dimensional exogenous (input) data.
# z is the n dimensional (estimated) state at time t,  E[z(t)|y(t-1), u(t)] denoted E[z(t)|t-1].
#    Note: In the case where there is no input u this corresponds to what
#     would usually be called the predicted state - not the filtered state.
# state is the history of the state.
# Om is the estimated output cov matrix.
# vt is the prediction error.
# pred is the history of the one-step ahead predictions, E[y(t)|y(t-1),u(t)] denoted E[y(t)|t-1].
# The history of the prediction error is given by y-pred[1:predictT,]or y-pred[1:sampleT,]
#     If error.weights is greater than zero then weighted prediction 
#     errors are calculated up to the horizon indicated
#     by the length of error.weights. The weights are applied to the squared
#     error at each period ahead.
# P is the one step ahead estimate of the state tracking error matrix at each 
# period. Cov{z(t)-E[z(t)|t-1]}
# trackError is the history of P.
#       Tracking error pt can only be calculated if Q and R are provided ( gain FALSE).
#       Using the Kalman gain K directly these are not necessary 
#       for the likelihood calculation,
#       but the tracking error cannot be calculated.
# If z0 is supplied it is used as the estimate of the state at time 0.
# If not supplied it is set to zero.
# If P0 is supplied it is used as the initial tracking error P(t=1|t=0).
# If not supplied it is set to I.
# could check that Q is symmetric  or positive definite but ...

if(!is.TSm.or.em(model)) TS.error.exit()
if (is.TSestModel(model)) model <- model$model
if (!is.SS(model)) TS.error.exit(clss="SS")
 
data <- freeze(data)
if(!check.consistent.dimensions(model,data)) stop("dimension error\n")
if (is.null(sampleT))  sampleT  <- output.periods(data)
if (is.null(predictT)) predictT <- sampleT
if (sampleT > predictT) stop("sampleT cannot exceed predictT.\n")
if (sampleT > output.periods(data))
    stop("sampleT cannot exceed length of data.\n")
if (0 != input.dimension(data))
  {if (input.periods(data) < predictT)
      stop("input data must be at least as long as requested prediction.\n")
   if (any(is.na(input.data(data)))) stop("input data cannot contain NAs.\n")
  }
if (any(is.na(output.data(data)))) stop("output data cannot contain NAs.\n")

gain <- is.innov.SS(model)
if (gain & return.track) 
   warning("Tracking error is zero for an innovations model. track will not be calculated.")

FF<-    model$F
H <-    model$H
n <- dim(FF)[2]
p <- dim(H)[1]
if (is.null(model$G))
  {m<-0
   G<-matrix(0,n,1)       # can't call compiled with 0 length arrays
   u <- matrix(0,predictT,1)
  }
else
  {m <- dim(model$G)[2]
   G <-model$G
   u <- input.data(data)
  } 
if (gain)            # K or Q,R can be NUll in model, which messes up compiled
   {K <-    model$K
    Q <-    matrix(0,1,1)      #not used
    R <-    matrix(0,1,1)      #not used
    track <-array(0,c(1,1,1))  #not used
   }
else
   {Q <-    model$Q
    if (ncol(Q)<n) Q <- cbind(Q,matrix(0,n,n-ncol(Q))) # Q assumed square in compiled
    R <-    model$R
    K <-    matrix(0,n,p)      # this is used
    if(return.track) track <-array(0,c(predictT,n,n))
    else             track <-array(0,c(1,1,1))  #not used
    storage.mode(track) <- "double"
   }
if (return.state | return.debug.info) state <- matrix(0,predictT,n)
else              state <- matrix(0,1,1)    #not used
storage.mode(state) <- "double"
if(is.null(model$z0)) z <-rep(0,n)   # initial state
else  z <-model$z0
if(is.null(model$P0)) P <- diag(1,n) # initial state tracking error 
else  P <-model$P0               # this is not used in innov. models

if (compiled)
  {r <- .Fortran("kf",
                  pred=matrix(0,predictT,p),    
                  as.integer(length(error.weights)), 
                  weighted.sqerror=matrix(0,sampleT,p),
                  error.weights=as.double(error.weights),   
                  as.logical(return.state),
                  state=state,         
                  as.logical(return.track & !gain),
                  track=track,                  
                  as.integer(m), 
                  as.integer(n), 
                  as.integer(p), 
                  sampleT=as.integer(sampleT), 
                  predictT=as.integer(predictT), 
                  as.integer(output.periods(data)),  
                  as.double(u), 
                  as.double(output.data(data)),  
                  as.double(FF),   
                  as.double(G),   
                  as.double(H),  
                  as.double(K), 
                  as.double(Q),      
                  as.double(R),    
                  as.logical(gain),
                  as.double(z),
                  as.double(P)) [c("pred","state","track","weighted.sqerror")]
   if (all(0==error.weights)) r$weighted.sqerror <- NULL
  }
else                  #  S version
  {y <- output.data(data)
   vt    <-  rep(0,p)     # initial prediction error
   pred  <- matrix(0,predictT,p) 
   wt.err <- NULL
   if (1 < length(error.weights)) wt.err <- matrix(0,predictT,p)
   if ( ! gain ) 
     {RR <- R %*% t(R)  
      QQ <- Q %*% t(Q)  
     }                            
                                   
   for (Time in 1:sampleT)  {
       if ( ! gain) 
         {PH  <-  P %*% t(H)
          ft    <- ( H %*% PH )  + RR         
          ft    <-  (ft + t(ft))/2   # force ft to be symmetric 
          K   <-  t(solve(ft,t(FF %*% PH)))  
          P   <-  (FF %*% P %*% t(FF) ) - ( K %*% H %*% P %*% t(FF) ) + QQ  # P(t|t-1)
          P   <-  (P + t(P))/2  # force symmetry (eliminate rounding error problems)
          if (return.track) track[Time,,] <- P   # P(t|t-1)
          # note P(t|t) = P-P%*%t(H)%*%solve(H%*/home/mfa5/gilp/dse/my/src/SCCS/s.dse1b.hs*%t(H)+RR)%*04/28/00*%P
         } 
         
       z<- c(FF%*%z) + c(K%*%vt)  # E[z(t)| t-1 ]
       if (m !=0) z<- z + c(G%*%u[Time,])
       if (return.state | return.debug.info) state[Time,]<- z
       pred[Time,] <- Ey  <-  c(H %*% z)       # predicted output     
       vt<-  y[Time,] - Ey                     # prediction error 
       if (any(0!=error.weights))          
        {wt.err[Time,] <- error.weights[1]*vt^2  # weighted sq prediction error
         if (length(error.weights)>1)
          {zh <-z
           for (h in 2:length(error.weights))
            if ( (Time+h-1) <= sampleT)
              {zh <-  c(FF%*%zh)
               if (h==2) zh <- zh + c(K%*%vt) # vt is 0 for h>2
               if (m !=0) zh<- zh + c(G%*%u[Time+h-1,])
               wt.err[Time,] <- wt.err[Time,] + 
                          error.weights[h]*(y[Time+h-1,] -  c(H %*% zh))^2
   }   }  }   }


#   prederror <- y[1:sampleT,,drop=F]-pred[1:sampleT,,drop=F]

   # now multi-step prediction to predictT 
   # This requires u but not y (y is ignored if it is supplied)
   if (predictT > sampleT)
    {for (Time in (sampleT+1):predictT)  
       {z <-  c(FF%*% z) 
        if (m !=0) z <-  z + c(G%*%u[Time,]) 
        if (Time==sampleT+1) z <- z + c(K%*%vt)
        if (return.state) state[Time,] <- z
        pred[Time,]  <-  c(H %*% z)                  # predicted output 
       }
     }
   r<- list(pred=pred, state=state, track=track, weighted.sqerror=wt.err) 
  }   # end of S version

tf <- truncate.tframe(tframe(output.data(data)), end=predictT)
tframe(r$pred) <- tf
if (! is.null(r$weighted.sqerror))  tframe(r$weighted.sqerror) <- tf

filter <-NULL
if (return.state | return.track)
  {if (gain|(!return.track))  filter$track <- NULL 
   else                       
     {filter$track <- r$track
      tframe(filter$track) <- tf
     }
   if (return.state)
     {filter$state <- r$state
      tframe(filter$state) <- tf
     }
  }
if((!is.null(result)) && (result == "pred")) return(r$pred)
r <- append(residual.stats(r$pred, output.data(data), sampleT, warn=warn), 
        list(error.weights=error.weights, weighted.sqerror=r$weighted.sqerror))

if (return.debug.info) 
   r$debug.info <- list(m=m, p=p, a=a,b=b,c=c, G=G,FF=FF,K=K,P=P, H=H, u=u,y=y,
        pred=pred, wt.err=wt.err, error.weights=error.weights, sampleT=sampleT)

if ( is.null(result)) 
   {r <-list(estimates=r, data=data, model=model, filter=filter) 
    return( classed(r, "TSestModel")) # constructor (l.SS)
   }
else 
   {if (result =="like") return(r$like[1]) # neg.log.like. from residual.stats
    else { return(r[[result]]) }
   }
"should never get to here in l.SS"
} # end of l.SS


smoother   <- function  (model, data, compiled=.DSECOMPILED)
{#  Fixed interval smoother for a model as returned by l.SS.
 # ref. appendix of Shumway and Stoffer,1982, J.of Time Series, 253-264,
 #        Jazwinski 1970, or Anderson and Moore.
 # Note: this does not allow the same option as l.SS for calculating over a
 #    sub-sample. Smoothing is done over the length of the available filter
 #    data (which will be calculated to the length of the data if not
 #    supplied). For models with an input smoothing will only be done to the
 #    length of input data if that is smaller than the available filter data. 
 # See l.SS for details of the model:
 #
 #        z(t) = Fz(t-1) + Gu(t) + Qe(t)
 #        y(t) = Hz(t)  + Rw(t)
 # 
 filter <- NULL
 estimates <- NULL
 if (is.TSestModel(model)) 
   {filter    <- model$filter
    estimates <- model$estimates
    model     <- TSmodel(model)
   }
 if  (!is.non.innov.SS(model)) TS.error.exit(clss=" non.innov SS")
 if  (is.null(filter$state) |  is.null(filter$track)) 
   {filter <- l(model,data, return.state=T,return.track=T)
    estimates <- filter$estimates
    filter    <- filter$filter
   }
 if (is.null(model$G))
  {m<-0
   G<-matrix(0,dim(model$F)[2],1)   # can't call compiled with 0 length arrays
   u <- matrix(0,nrow(filter$state),1)
  }
else
  {m <- dim(model$G)[2]
   G <-model$G
   u <- input.data(data)
  } 
sampleT  <-min(nrow(u), nrow(filter$state), dim(filter$track)[1])
 QQ <- model$Q %*% t(model$Q)           
 RR <- model$R %*% t(model$R) 
 n <- dim(model$F)[2]          
 if (compiled)
   {r<-.Fortran("smooth", 
                         state=filter$state,     # state, 
                         track=filter$track,     #trackerror
                         as.double(u),           # input
                         as.double(output.data(data)), # output
                         as.integer(n),                #n
                         as.integer(m),                #m
                         as.integer(dim(model$H)[1]),  #p 
                         sampleT =as.integer(sampleT), 
                         as.double(model$F),   
                         as.double(G),   
                         as.double(model$H), 
                         as.double(RR),
                         as.double(matrix(0,n,n)),   # scratch array
                         as.double(matrix(0,n,n)),   # scratch array
                         as.double(matrix(0,n,n)),   # scratch array
                         as.double(matrix(0,n,n)),   # scratch array
                         as.double(rep(0,n))         # scratch array
                   ) [c("state","track")]
   }
 else   # S version
   {FF<-  model$F
    H <-  model$H
    #   filter$state is the one step ahead state estimate E{z(t)| y(t-1), u(t)}
    #   zt below is the filter state estimate E{z(t)| y(t), u(t+1)}
    #   filter$track is tracking error P(t|t-1)
    sm <- array(NA,dim(filter$state))  # smoother state estimate
    sm[sampleT,] <-filter$state[sampleT,]
    tr <- array(NA,dim(filter$track))  # smoother tracking error
    tr[sampleT,,] <-filter$track[sampleT,,]
    for (Time in (sampleT-1):1) 
      {K <- filter$track[Time,,] %*% t(H) %*% 
              solve(H %*% filter$track[Time,,] %*% t(H) + RR) #(A5)
       zt <- filter$state[Time,] + K %*% 
       		(output.data(data)[Time,] - H %*% filter$state[Time,]) #(A6)
       if (m!=0) zt <- zt - G %*% u[Time+1,]
       P <- filter$track[Time,,] - K %*% H %*% filter$track[Time,,]  #P(t|t)  (A7)
       P <- (P+t(P))/2 #force symmetry to avoid rounding problems
       J <- P %*% t(FF) %*% solve(filter$track[Time+1,,])             #(A8) 
       if (m==0)                                          
          sm[Time,] <- zt + J %*% (sm[Time+1,] - FF %*% zt)              #(A9) 
       else 
          sm[Time,] <- zt + J %*% (sm[Time+1,] - FF %*% zt - G %*% u[Time+1,]) #check   
       P <- P + J %*% (tr[Time+1,,] - filter$track[Time+1,,]) %*% t(J)    #(A10)
       tr[Time,,]<- (P+t(P))/2   #force symmetry to avoid rounding problems
      }
     r <- list(state=sm, track=tr) 
    }  # end S version
 
  state <- tframed(r$state, list(start=start(output.data(data)),
              frequency= frequency(output.data(data))), 
              names=dimnames(filter$state)[[2]]) 
  r <-(list(estimates=estimates, data=data, model=model, 
            filter=filter, smooth=list(state=state, track=r$track) ) )
   classed(r, "TSestModel") # constructor (smoother)
} # end of smoother
  



############################################################

#     parameter estimation functions   <<<<<<<<<<

############################################################


est.VARX <- function(...)
  {stop("est.VARX is defunct. Use est.VARX.ls or est.VARX.ar.")}

est.VARX.ls.old <- function(data, subtract.means=F, standardize=F, max.lag=NULL, trend=F) 
{# Estimate VAR model with exogenous variable using lsfit(). 
 # Returns a TSestModel.
 # This is very similar to estimating Markov parameters (see est.SS.Mittnik).
 # Residuals,etc, are calculated by evaluating the estimated model with ARMA.
 # Data should be of class TSdata.
   if (is.null(max.lag)) max.lag <- 6
   data <- freeze(data)
   m <-  input.dimension(data)
   p <- output.dimension(data)
   if(is.null(m))  m <- 0
   N <- output.periods(data)
   if (subtract.means)
    {if(m!=0)input.data(data)<-input.data(data)-t(matrix(apply(input.data(data),2, mean), m,N))
     output.data(data)<- output.data(data) - t(matrix(apply(output.data(data),2, mean), p,N))
    }
   if (standardize)
     {svd.cov <- svd(var(output.data(data)))
      output.data(data) <- output.data(data) %*% svd.cov$u %*% diag(1/svd.cov$d^.5, ncol=p)
     }
      # shift input to give feedthrough in one period
   if (m != 0) {z <- cbind(input.data(data)[2:N,],output.data(data)[1:(N-1),])}
   else z <- output.data(data)

 # The matrix Past is blocks of data:
 #  [in | out-1 | in-1 | out-2 | ... | in-max.lag | out-max.lag-1 ]
 # so the coef. matrix M has a corresponding structure.
 
   Past <- matrix(NA,N-max.lag,(p+m)*(max.lag))
   for (i in 0:(max.lag-1)) 
      Past[,(1+(m+p)*i):((m+p)*(1+i))] <-z[(max.lag-i):(N-1-i),]
   M <- t(lsfit(Past,output.data(data)[(max.lag+1):N,,drop=F],intercept=trend)$coef)
   if (standardize && (m!=0))  # correct exogenous blocks for normalization
     {Tinv <- diag(svd.cov$d^.5, ncol=p)%*%svd.cov$u
      for (i in 0:(max.lag-1)) 
         M[,(1+(m+p)*i):(m+(m+p)*i)] <- Tinv %*% M[,(1+(m+p)*i):(m+(m+p)*i)]
     }
   TREND <- NULL
   if (trend)
     {TREND <- M[,1]
      M<-M[,2:(dim(M)[2])]
     }
   A <- array(NA, c(1 + max.lag, p, p))
   A[1,,] <-diag(1, p)
   for (i in 0:(max.lag-1)) 
          A[2+i,,] <-  -M[,(m+1+(m+p)*i):(m+p+(m+p)*i)]
   if (m==0) C <- NULL   # no exog. variable
   else               # NB. there is an implicit shift in input.data(data)
      {C <-array(NA,c(max.lag,p,m))
       for (i in 0:(max.lag-1)) 
         C[1+i,,] <- M[,(1+(m+p)*i):(m+(m+p)*i)]
      }
   B <- array(diag(1,p),c(1,p,p))
   l(ARMA(description="model estimated by est.VARX.ls",
        A=A,B=B,C=C,TREND=TREND, 
         input.names =  input.series.names(data), 
        output.names = output.series.names(data)), data)
}


est.VARX.ls <- function(data, subtract.means=F, re.add.means=T, standardize=F, 
     unstandardize=T, max.lag=NULL, trend=F, lag.weight=1.0, warn=T) 
{# Estimate VAR model with exogenous variable using lsfit(). 
 # Returns a TSestModel.
 # This is very similar to estimating Markov parameters (see est.SS.Mittnik).
 # Residuals,etc, are calculated by evaluating the estimated model with ARMA.
 # Data should be of class TSdata.
 # lag.weight is an exponential weight applied to lags. It should be in (0,1].
   if (is.null(max.lag)) max.lag <- 6
   data <- freeze(data)
   names <- series.names(data)
   missing.data <- any(is.na(data$output),is.na(data$output))
   m <-  input.dimension(data)
   p <- output.dimension(data)
   N <- output.periods(data)
   if (standardize)
     {svd.cov <- svd(var(output.data(data)))
      scalefac <- svd.cov$u %*% diag(1/svd.cov$d^.5, ncol=p)
      data <- scale(data, list(output=scalefac))
     }
   if (subtract.means)
    {if(m!=0)
       {input.means<-apply(input.data(data),2, mean)
        input.data(data)<-input.data(data)-t(matrix( input.means, m,N))
       }
     output.means <- apply(output.data(data),2, mean)
     output.data(data)  <- output.data(data) - t(matrix(output.means, p,N))
    }
      # shift input to give feedthrough in one period
   if (m != 0) {z <- cbind(input.data(data)[2:N,],output.data(data)[1:(N-1),])}
   else z <- output.data(data)

 # The matrix Past is blocks of data:
 #  [in | out-1 | in-1 | out-2 | ... | in-max.lag | out-max.lag-1 ]
 # so the coef. matrix M has a corresponding structure.
 
   Past <- matrix(NA,N-max.lag,(p+m)*(max.lag))
   for (i in 0:(max.lag-1)) 
      Past[,(1+(m+p)*i):((m+p)*(1+i))] <-z[(max.lag-i):(N-1-i),] /(lag.weight^i)
   fit <- lsfit(Past,output.data(data)[(max.lag+1):N,,drop=F],intercept=trend)
   if(missing.data)
     fit.res <-TSdata(output=fit$residual) #used only in the case of missing data for scaling
   M <- t(fit$coef)
   # correct exogenous blocks for normalization:
   if (standardize && (m!=0)) 
     {Tinv <- diag(svd.cov$d^.5, ncol=p)%*%svd.cov$u
      for (i in 0:(max.lag-1)) 
         M[,(1+(m+p)*i):(m+(m+p)*i)] <- Tinv %*% M[,(1+(m+p)*i):(m+(m+p)*i)]
     }
   TREND <- NULL
   if (trend)
     {TREND <- M[,1]
      M<-M[,2:(dim(M)[2]),drop=F]
     }
   if (subtract.means & re.add.means)
    {if(m!=0) 
       {input.data(data)<-input.data(data) + t(matrix( input.means, m,N))
        Past<-Past +
           t(matrix(c(input.means,output.means),(p+m)*(max.lag),N-max.lag))
       }
     else
        Past <-Past+t(matrix(output.means, (p+m)*(max.lag),N-max.lag))
     output.data(data)  <- output.data(data) + t(matrix(output.means, p,N))
     # and correct estimation for non-zero mean:
     M<-M+est.VARX.mean.correction(Past, 
                       output.data(data)[(max.lag+1):N,,drop=F],M, warn=warn)
    }
   A <- array(NA, c(1 + max.lag, p, p))
   A[1,,] <-diag(1, p)
   for (i in 0:(max.lag-1)) 
          A[2+i,,] <-  -M[,(m+1+(m+p)*i):(m+p+(m+p)*i),drop=F] %*% 
                                 diag(lag.weight^i,p)
   if (m==0) C <- NULL   # no exog. variable
   else               # NB. there is an implicit shift in input.data(data)
      {C <-array(NA,c(max.lag,p,m))
       for (i in 0:(max.lag-1)) 
         C[1+i,,] <- M[,(1+(m+p)*i):(m+(m+p)*i),drop=F]  %*% 
                                 diag(lag.weight^i,m)
      }
   B <- array(diag(1,p),c(1,p,p))
   model <-ARMA( description="model estimated by est.VARX.ls",
              A=A,B=B,C=C,TREND=TREND)
   series.names(model) <- series.names(data)

   if (standardize & unstandardize)
     {scalefac <- solve(scalefac)
      data <- scale(data,  list(output=scalefac))
      model<- scale(model, list(output=scalefac))
      if(missing.data) fit.res <- scale(fit.res, list(output=scalefac))
     }

   if(missing.data)
       {if (warn) warning(
          "missing data kludge. Predictions are reconstructed from lsfit residuals")
        return(fake.TSestModel.missing.data(model,data, fit.res$output,max.lag))
       }
   else return(l(model, data, warn=warn))
}

fake.TSestModel.missing.data <- function(model,data, residual, max.lag)
  {pred <- rbind(matrix(NA,max.lag,output.dimension(data)),residual) + 
                                                           output.data(data)
   r <- list(estimates = residual.stats(pred, output.data(data), warn=warn),
               data = data, model = model)
   classed(r, "TSestModel") # fake missing data constructor
  }

est.VARX.mean.correction <- function(X, y, bbar,
                     fuzz=sqrt(.Machine$double.eps), warn=T)
{# correction for model estimated with means subtracted
 Xbar <- t(array(apply(X, 2, mean), rev(dim(X))))
 ybar <- t(array(apply(y, 2, mean), rev(dim(y))))
 v <- svd(t(X)%*%X) # this is more robust than solve()
 if (warn && any(abs(v$d[1]*fuzz) > abs(v$d) ) ) 
   warning("The covariance matrix is nearly singular. Check for linearly related data.")
# if(1 == length(v$d))OmInv <- v$v %*% (1/v$d) %*% t(v$u)
# else OmInv <- v$v %*% diag(1/v$d) %*% t(v$u)	
#  following is equivalent
 OmInv <-  v$v %*% sweep(t(v$u),1,1/v$d, "*") 
 t(-OmInv %*% ( 
        (2*t(Xbar)%*%X - t(Xbar)%*%Xbar) %*% t(bbar) 
         - t(Xbar)%*%y - t(X)%*%ybar + t(Xbar)%*%ybar ))
}


est.VARX.ar <- function(data, subtract.means=F,  re.add.means=T, standardize=F, 
         unstandardize=T, aic=T, max.lag=NULL, method="yule-walker", warn=T) 
{
# Estimate VAR model with exogenous variable using ar(). Returns a TSestModel.
# Residuals,etc, are calculated by evaluating the estimated model with ARMA.
# Use Splus procedure ar  and combine exogeneous variables.
# Note: ar uses a Yule-Walker approach (uses autocorrelations) so effectively the 
#   model is for data with means removed. Thus subtract.means does not make much
#   difference and re.add.means must be T to get back to a model for the 
#   original data.
# Conventon for AR(0)  and sign are changed to ARMA format.
# Data should be of class TSdata.
# The exog. variable is shifted so contemporaneous effects enter.
# the model for the exog. variable (as estimated by ar() is  discarded.
   data <- freeze(data)
   m <-  input.dimension(data)
   p <- output.dimension(data)
   N <- output.periods(data)
   if (standardize)
     {svd.cov <- svd(var(output.data(data)))
      scalefac <- svd.cov$u %*% diag(1/svd.cov$d^.5, ncol=p)
      data <- scale(data, list(output=scalefac))
     }
   if(m!=0) input.means<-apply(input.data(data),2, mean)
   output.means <- apply(output.data(data),2, mean)
   if (subtract.means)
    {if(m!=0) input.data(data)<-input.data(data)-t(matrix( input.means, m,N))
     output.data(data)  <- output.data(data) - t(matrix(output.means, p,N))
    }
   if (m==0)  zdata <- output.data(data)  # no exog. variable
   else       zdata <- cbind(input.data(data),output.data(data))
         # NB. there is an implicit shift in input.data(data) in the line above
         #   because ar estimates lag parameters,
         # so C[1,,] is for one lag in u.
   if (is.null(max.lag))  AC<- DSE.ar(zdata, aic=aic, method=method)
   else                   AC<- DSE.ar(zdata, aic=aic, method=method, order.max=max.lag)
   if (re.add.means)
     {if (subtract.means)
        {if(m!=0) input.data(data)<-input.data(data) + t(matrix( input.means, m,N))
         output.data(data)  <- output.data(data) + t(matrix(output.means, p,N))
        }
      # and correct estimation for non-zero mean:
      max.lag <- AC$order
      if (max.lag==0) stop("all lags eliminated by AIC order selection.")
      if (m==0)  zdata <- output.data(data)  # no exog. variable
      else       zdata <- cbind(input.data(data),output.data(data))
      Past <- matrix(NA,N-max.lag,(p+m)*(max.lag))
      for (i in 0:(max.lag-1)) 
         Past[,(1+(m+p)*i):((m+p)*(1+i))] <-zdata[(max.lag-i):(N-1-i),]
      M <-est.VARX.mean.correction(Past, zdata[(max.lag+1):N,,drop=F],
                  matrix(aperm(AC$ar, c(2,3,1)),m+p,(m+p)*max.lag), warn=warn)
      AC$ar<-AC$ar + aperm(array(M,c(m+p,m+p,max.lag)), c(3,1,2))
     }
   A <- array(0, c(1 + AC$order, p, p))
   A[1,,] <-diag(1, p)
   if (0==AC$order)
      warning("lagged output variables eliminated by AIC order selection.")
   else 
      A[2:(1+AC$order),,] <-  -AC$ar[, (m+1):(m+p), (m+1):(m+p), drop=F]
   if (m==0) C <- NULL
   else 
     {if (0==AC$order)
             {warning("input variables eliminated by AIC order selection.")
              C <-array(0, c(1,p,m))
             }
      else C <-array(AC$ar[,(m+1):(m+p),1:m],c(AC$order,p,m))
     }
   B <- array(diag(1,p),c(1,p,p))
   model <-ARMA(
            description="model estimated by est.VARX.ar",
            A=A,B=B,C=C, 
            names = series.names(data) )
 
   if (standardize & unstandardize)
     {scalefac <- solve(scalefac)
      data <- scale(data,  list(output=scalefac))
      model<- scale(model, list(output=scalefac))
     }
   l(model, data, warn=warn)
}

old.est.VARX.ar <- function(data, subtract.means=F,  re.add.means=T, standardize=F, 
    unstandardize=T, aic=T, max.lag=NULL, method="yule-walker") 
{
# Estimate VAR model with exogenous variable using ar(). Returns a TSestModel.
# Residuals,etc, are calculated by evaluating the estimated model with ARMA.
# Use Splus procedure ar  and combine exogeneous variables.
# Conventon for AR(0)  and sign are changed to ARMA format.
# Data should be of class TSdata.
# The exog. variable is shifted so contemporaneous effects enter.
# the model for the exog. variable (as estimated by ar() is  discarded.
   data <- freeze(data)
   m <-  input.dimension(data)
   p <- output.dimension(data)
   if(is.null(m))  m <- 0
   N <- output.periods(data)
   if (subtract.means)
    {if(m!=0)
       {input.means<-apply(input.data(data),2, mean)
        input.data(data)<-input.data(data)-t(matrix( input.means, m,N))
       }
     output.means <- apply(output.data(data),2, mean)
     output.data(data)  <- output.data(data) - t(matrix(output.means, p,N))
    }
   if (standardize)
     {svd.cov <- svd(var(output.data(data)))
      scalefac <- svd.cov$u %*% diag(1/svd.cov$d^.5, ncol=p)
      data <- scale(data, list(output=scalefac))
     }
   if (m==0)    # no exog. variable
      {if (is.null(max.lag))   AC<- DSE.ar(output.data(data), aic=aic, method=method)
       else AC<- DSE.ar(output.data(data), order.max=max.lag, aic=aic, method=method)
       A <- array(0, c(1 + AC$order, p, p))
       A[1,,] <-diag(1, p)
       if (0<AC$order) A[2:(1+AC$order),,] <-  -AC$ar
       C <- NULL
      }
   else               # NB. there is an implicit shift in input.data(data)
      {               #   because ar estimates lag parameters,
                      # so C[1,,] is for one lag in u.
       if (is.null(max.lag))
         AC<- DSE.ar(cbind(input.data(data),output.data(data)), aic=aic, method=method) 
       else   
         AC<- DSE.ar(cbind(input.data(data),output.data(data)), order.max=max.lag, aic=aic, method=method) 
       A <- array(0, c(1 + AC$order, p, p))
       A[1,,] <-diag(1, p)
       if (0<AC$order) 
         {A[2:(1+AC$order),,] <-  -AC$ar[, (m+1):(m+p), (m+1):(m+p), drop=F]
          C <-array(AC$ar[,(m+1):(m+p),1:m],c(AC$order,p,m))
         }
      }
#   B <- array(AC$var.pred,c(1,p,p))
   B <- array(diag(1,p),c(1,p,p))
   model <-ARMA(description="model estimated by est.VARX.ls",
                   A=A,B=B,C=C, 
                  names = series.names(data) )

   if (standardize & unstandardize)
     {scalefac <- solve(scalefac)
      data <- scale(data,  list(output=scalefac))
      model<- scale(model, list(output=scalefac))
     }
   if (subtract.means & re.add.means)
    {if(m!=0) input.data(data)<-input.data(data) + t(matrix( input.means, m,N))
     output.data(data)  <- output.data(data) + t(matrix(output.means, p,N))
    }
   l(model, data)
}

est.SS.from.VARX<- function # estimate a VARX model and convert to state space
   (data, warn=T, ...)
{#  estimate a nested-balanced state space model by svd a la Mittnik from
 #   least squares estimate of VAR coefficents.
 model <-est.VARX.ls(data, warn=warn, ...)
 l(to.SS(model$model), model$data, warn=warn)
}




############################################################

#     model balancing functions   <<<<<<<<<<

############################################################

balance.Mittnik<- function # calculate a nested-balanced state space model by svd
   (model, n=NULL) {
# n is intended primarily for producing a state space model from the markov
#  parameters of an ARMA model, but if it is supplied with an SS model the
#  result will be a model with state dimension n based on the n largest
#  singular values of the svd of a Hankel matrix of markov parameters generated
#  by the original model. If n is not supplied then the singular values are
#  printed and the program prompts for n.

  if(!is.TSm.or.em(model)) TS.error.exit()
  if (is.TSestModel(model)) model <- model$model
  m <- input.dimension(model)
  newmodel <- balance.Mittnik.svd(markov.parms(model), m, n)$model
  newmodel$description <- paste(model$description,"converted to", newmodel$description)
  series.names(newmodel)  <-  series.names(model)
  newmodel
}


balance.Mittnik.svd <- function(M, m, n=NULL)
{ # Calculate a nested-balanced state space model by svd a la Mittnik.
  # If state dim n is supplied then svd criteria are not calculated and 
  # the given n is used. Otherwise, the singular values are printed and 
  # the program prompts for n.
  # M is a matrix with p x (m+p)  blocks giving the markov parameters,
  # that is, the first row of the Hankel matrix. It can be generated from the
  # model as in the function markov.parms, or from the data, as in the function
  # est.SS.Mittnik.
  # m is the dimension of input series, which is needed to decompose M.
  # The output dimension p is taken from nrow(M).

#                   # Form k block Hankel Matrix from M.
   p <- nrow(M)     # dim of endo. series
   r <- m + p       # each sub-matrix is p x r   (= p x (m+p) )
   k<- dim(M)[2] / r
   Hkl <- matrix(0, p*k, r*k) 
   for(i in 1:k)             # Hankel with 0s in SE half  
     Hkl[(1+p*(i-1)):(p*i), 1:(r*(1+k-i))]<- M[,(1+r*(i-1)):(r*k),drop=F]
# note: if last block of M is 0, which is often the case, then filling
#   with zeros, as above, is correct.
#   k <- k %/% 2
#   Hkl <- matrix(0, p*k, r*k) 
#   for (i in 1:k)              # (smaller) completely filled Hankel
#     {for (j in 1:k)       
#        {Hkl[(1+p*(i-1)):(p*i), (1+r*(j-1)):(r*j)] <-M[ ,(1+r*(i+j-2)):(r*(i+j-1))] }}

   svd.of.Hkl <- svd(Hkl)
   shifted.Hkl <- Hkl[,(r+1):dim(Hkl)[2]]
   shifted.Hkl <- cbind(shifted.Hkl,matrix(0,p*k,r))
   rtQ <- diag(sqrt(svd.of.Hkl$d))
   rtQ.inv <- diag(1/sqrt(svd.of.Hkl$d))   
   o.mtr <- svd.of.Hkl$u %*% rtQ 
   o.inv <- t(svd.of.Hkl$u %*% rtQ.inv )
   c.mtr <- rtQ %*% t(svd.of.Hkl$v)
   c.inv <- t(rtQ.inv %*% t(svd.of.Hkl$v))
   svd.crit <- svd.of.Hkl$d
   c.mtr[svd.crit==0,] <-0     # this gets rid of NAs but the resulting
   c.inv[,svd.crit==0] <-0     #  model may not be minimal
   o.inv[svd.crit==0,] <-0     # eg. F may have zero rows and columns
   o.mtr[,svd.crit==0] <-0     #   (specifically if the model included a trend)
   if (is.null(n))
     {svd.crit <- svd.criteria(svd.of.Hkl$d)
      n <- read.int("Enter the number of singular values to use for balanced model: ")
     }
   H  <- o.mtr[1:p,1:n,drop=F]
   FF <- o.inv[1:n,,drop=F] %*% shifted.Hkl%*%c.inv[,1:n,drop=F]
   if (m == 0) G <- NULL             # no exog.
   else        G <- c.mtr[1:n,1:m,drop=F]  # exog.
   K  <- c.mtr[1:n,(m+1):(m+p),drop=F]
   FF <- FF + K%*%H  #converts from system with lagged outputs as 
                    #   inputs see Mittnik p1190.
  #browser()
  #  good checks here are (with n=length(svd.of.Hkl$d)):
  #   0 == max(abs(shifted.Hkl - o.mtr[,1:n] %*% (FF-K%*%H) %*% c.mtr[1:n,]))
  #   0 != max(abs(shifted.Hkl))
  model<-SS(description="nested-balanced model a la Mittnik",
              F=FF,G=G,H=H,K= K)
  list(crit=svd.crit,model=model)
}

############################################################

#     statistical test functions  <<<<<<<<<<

############################################################

Portmanteau <- function (res){
  # Portmanteau statistic for residual
  if (is.R()) if (!require("ts", warn.conflicts = F)) stop("package ts is required.")
  ac <- acf(res,type="covariance", plot=F)$acf
  p <- dim(ac)[1]
#  a0 <- solve(ac[1,,])  the following is more robust than solve for
#              degenerate densities
  v <- svd(ac[1,,])
#  if(1 == length(v$d)) a0 <- v$v %*%     (1/v$d) %*% t(v$u)
#	           else a0 <- v$v %*% diag(1/v$d) %*% t(v$u)	
#  following is equivalent
  a0 <-  v$v %*% sweep(t(v$u),1,1/v$d, "*") 
  P <-0
  for (i in 2:p) 
    {P <- P + sum(diag(t(ac[i,,]) %*% a0 %*% ac[i,,] %*% a0))
    }
  dim(res)[1]*P
}


check.residuals <- function(obj1, ...)  UseMethod("check.residuals")
# autocorrelations <- function(obj1, ...) UseMethod("check.residuals")

check.residuals.TSestModel <- function (model, ...)
	{invisible(check.residuals(TSdata(output= model$estimates$pred - 
                                                  output.data(model) ), ...))
} 

check.residuals.TSdata <- function (data, ac=T, pac=T, select=NULL, drop=NULL, plot.=T, graphs.per.page=5, verbose=F)
{# If select is not null it should be a vector of the column indices of 
 #    residuals to use.
 # If drop is not null it should be a vector of the row indices of residuals
 #  which are not to be used. Typically this can be used to get rid
 #  of bad initial conditions (eg. drop=seq(10) ) or outliers.
  names <- output.series.names(data)
  if (is.null(select)) resid <- output.data(data)
  else                {resid <- output.data(data, series=select)
                       names <- names[select] }
  if (!is.null(drop))  resid <- resid[-drop,, drop=F]
  mn<-apply(resid,2,mean)
  acr <-NULL
  pacr<-NULL
  cov <- var(resid)
  if (verbose) 
    {cat("residual means: \n") ; print(mn); cat("\n")
     cat("residual cov  : \n") ; print(cov) ; cat("\n")
    }
  p <- dim(resid)[2]
  resid0 <-resid - t(array(apply(resid,2,mean),rev(dim(resid)))) # mean 0
  cusum <- apply(resid0,2,cumsum)/ t(array(diag(var(resid0)),rev(dim(resid0))))
  if(plot. && exists.graphics.device()) 
    {graphs.per.page <- min(p, graphs.per.page)
     old.par <-par(mfcol = c(3, graphs.per.page), mar = c(5.1, 4.1,3.1, 0.1) ) #c(5,4.1,5,0.1) c(2.1, 4.1,3.1, 0.1)
     on.exit(par(old.par))
     for (i in 1:p) 
          {tfplot(resid[,i], xlab=names[i])
           if (i %% graphs.per.page == ceiling(graphs.per.page/2)) 
                 title(main ="Residuals ")
           if (i %% graphs.per.page == 0) 
                 title(main = paste("       page ", floor(i / graphs.per.page)))
           tfplot(cusum[,i], xlab=names[i])
           if (i %% graphs.per.page == ceiling(graphs.per.page/2)) 
                 title(main = "Cusum")
           if (exists("ksmooth")) 
                       rd<-ksmooth(resid[,i],bandwidth=var(resid[,i])^0.5)
           else  if (exists("density"))
                       rd <- density(resid[,i],       bw=var(resid[,i])^0.5)
           else
        stop("Neither ksmooth nor density are available to calculate the tfplot.")
           plot(rd,type="l",xlab=names[i],ylab="")
           if (i %% graphs.per.page == ceiling(graphs.per.page/2))
              title(main = "kernel estimate of residual distribution")
          }
     if (ac)
       {par(mfrow = c(1, 1), mar = c(2.1, 4.1,3.1, 0.1), oma=c(0,0,5,0) )
        acr  <-acf(resid, plot=T)$acf
        mtext("Autocorrelations", side=3, outer=T, cex=1.5)
       }
     if (pac)
       {par(mfrow = c(1, 1), mar = c(2.1, 4.1,3.1, 0.1), oma=c(0,0,5,0) )
        pacr <-acf(resid, plot=T, type= "partial")$acf 
        mtext("Partial Autocorrelations", side=3, outer=T, cex=1.5)
       }
    }
  else 
    {if (is.R()) if (!require("ts", warn.conflicts = F)) stop("package ts is required.")
     if (ac)  acr  <-acf(resid, plot=F)$acf
     if (pac) pacr <-acf(resid, plot=F, type= "partial")$acf 
    }
  if (ac & verbose)
    {cat("residual auto-correlations:\n")
     cat("      lag:   ")
     for (i in 1: dim(acr)[1])  cat(i,"        ")  
     cat("\n") 
     for (i in 1:p) { cat(i,": "); cat(acr[,i,i]); cat("\n")  }
    }
  if (pac & verbose)
    {cat("partial auto-correlations:\n")
     cat("      lag:   ")
     for (i in 1: dim(pacr)[1])  cat(i,"        ")  
     cat("\n") 
     for (i in 1:p) { cat(i,": "); cat(pacr[,i,i]); cat("\n")  }
    }
#  cat("residual normality tests:\n")
#  cat("hetros. tests:\n")

  skewness <- apply(sweep(resid,2,mn)^3,2,mean) / diag(cov)^(3/2)
  kurtosis <- apply(sweep(resid,2,mn)^4,2,mean) / diag(cov)^2
  invisible(list(residuals=resid, mean=mn, cov=cov, acf=acr, pacf=pacr, 
                 cusum=cusum, skewness=skewness, kurtosis=kurtosis))
}



information.tests     <- function # print model selection criteria
   (..., sample.start=1,sample.end=NULL, Print=T, warn=T){
  #  for models statistics ..., where ... are the names of the
  #  list information as returned by like.
  #  likes returns neg. log likelihood as lst$like[4].
  if (Print) criteria.table.heading()
  values <- NULL
  options(width=100)
  for (lst in list(...) ) 
    {z <-information.tests.calculations(lst,
    		 sample.start=sample.start,sample.end=sample.end, warn=warn)
     values <-rbind(values, z)
     if (Print)
       {print(c(z),digits=4)
        cat("\n")
       }
    }
  if (Print & (1 <dim(values)[1]) )
    {cat("opt     ")
     opt <-apply(values,2,order)[1,]  # minimum
     for (i in 1:length(opt)) cat(opt[i],"      ")
     cat("\n")
    }
  if (Print) criteria.table.legend()
  invisible(values)
}


information.tests.calculations <- function # return model selection criteria
     (lst, sample.start=1,sample.end=NULL, warn=T){
   resid <- lst$estimates$pred-output.data(lst$data)
    # the following line is just to work around a bug with old style time series
   if (ncol(output.data(lst$data))==1) dim(resid) <- dim(output.data(lst$data))
   if (is.null(sample.end)) sample.end <- nrow(resid)
   resid <- resid[sample.start:sample.end,,drop=F]
   ml <-   residual.stats(resid, NULL, warn=warn)$like[1] # neg.log(likelihood)
# previously   ml <-   L(resid)[1]     # neg. log( likelihood ).
   n  <-  length(lst$model$parms)      # No. of parameters.
   # nt is theorical dimension of parameter space    n(m+2p)
   if (is.ARMA(lst$model)) nt <- NA 
   if (is.SS(lst$model))  
      if (is.null(lst$model$G)) nt <- nrow(lst$model$F)*2*nrow(lst$model$H)
      else   nt <- nrow(lst$model$F)*(ncol(lst$model$G)+2*nrow(lst$model$H))
   r  <- nrow(lst$estimates$pred)*ncol(lst$estimates$pred) #No. of residuals.
   port <-Portmanteau(resid)
   aic <-  2*ml + 2*n             # AIC
   ops  <- options(warn=-1)
   on.exit(options(ops))
   bic <-  2*ml + n*log(r)        # BIC
   gvc <-  2*ml - 2*r*log(1-n/r)  # GCV
   rice<-  2*ml - r*log(1-2*n/r)  # RICE
   fpe <-  2*ml + r*(log(1+(n/r))-log(1-(n/r)))  # FPE
   taic <-  2*ml + 2*nt             # AIC
   tbic <-  2*ml + nt*log(r)        # BIC
   tgvc <-  2*ml - 2*r*log(1-nt/r)  # GCV
   trice<-  2*ml - r*log(1-2*nt/r)  # RICE
   tfpe <-  2*ml + r*(log(1+(nt/r))-log(1-(nt/r)))  # FPE
   z<- matrix(c(port,ml,aic,bic,gvc,rice,fpe,taic,tbic,tgvc,trice,tfpe),1,12)
   dimnames(z)<-list(NULL,c("port","like","aic","bic","gvc","rice","fpe","taic",
                   "tbic","tgvc","trice","tfpe"))
   z
}

criteria.table.heading <- function(){
        cat("                    based on no.of parameters     based on theoretical parameter dim.","\n")
        cat("       PORT  -ln(L)  AIC   BIC   GVC  RICE   FPE   AIC   BIC   GVC   RICE   FPE\n")
}

criteria.table.nheading <- function(){
        cat("                    based on no.of parameters     based on theoretical parameter dim.","\n")
        cat("dim.   PORT  -ln(L)  AIC   BIC   GVC  RICE   FPE   AIC   BIC   GVC   RICE   FPE\n")
}

criteria.table.legend <- function(){
        cat("  PORT  - Portmanteau test                     ") 
        cat("  -ln(L)- neg. log likelihood                  \n")
        cat("  AIC   - neg. Akaike Information Criterion    ")  
        cat("  BIC   - neg. Bayes  Information Criterion    \n")
        cat("  GVC   - Generalized Cross Validation         ") 
        cat("  RICE  - Rice Criterion                       \n")
        cat("  FPE   - Final Prediction Error               \n") 
        cat(" WARNING - These calculations do not account for trend parameters in ARMA models.\n") 
}


svd.criteria <- function(sv){
   cat("\n SINGULAR VALUES OF THE HANKEL MATRIX:\n")
   print(sv,digits=3)
   svsqr.vct <- sv^2/sum(sv^2)    
   cat("\n GELFAND & YAGLOM INFORMATION CRITERIA:\n")
   GY <-cumsum(log(1-svsqr.vct))/sum(log(1-svsqr.vct))
   print(GY,digits=3)
   cat("\n RATIO OF SINGULAR VALUES TO MAX SINGULAR VALUE:\n")
   print(sv/sv[1],digits=3)
   cbind(sv,GY,sv/sv[1])
}   

#######################################################################

#                    end

#######################################################################

