% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wmean_fn.R
\name{estimate_wmean}
\alias{estimate_wmean}
\title{Compute the estimate of the weighted mean parameter based on 
estimated PMF in each treatment arm.}
\usage{
estimate_wmean(
  pmf_est,
  treat,
  out,
  out_levels,
  out_weights,
  treat_prob_est,
  return_cov = TRUE
)
}
\arguments{
\item{pmf_est}{List of treatment-specific PMF estimates.}

\item{treat}{A \code{numeric} vector containing treatment status. Missing
values are not allowed unless the corresponding entry in \code{out} is also missing. 
Only values of 0 or 1 are treated as actual treatment levels. Any other value is assumed 
to encode a value for which the outcome is missing and the corresponding outcome value is 
ignored.}

\item{out}{A \code{numeric} vector containing the outcomes. Missing outcomes are 
allowed.}

\item{out_levels}{A \code{numeric} vector containing all ordered levels of the 
outcome.}

\item{out_weights}{A vector of \code{numeric} weights with length equal to the length 
of \code{out_levels}.}

\item{treat_prob_est}{Estimated probability of treatments, output from call
to \code{estimate_treat_prob}.}

\item{return_cov}{If \code{TRUE} the estimated covariance matrix is returned.}
}
\value{
List with estimates of treatment-specific means and difference in means. 
If \code{return_cov = TRUE}, also includes covariance matrix estimates.
}
\description{
Compute the estimate of the weighted mean parameter based on 
estimated PMF in each treatment arm.
}
