% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api-progress.R
\name{failed}
\alias{failed}
\title{List failed targets.
to \code{\link[=make]{make()}}.}
\usage{
failed(path = getwd(), search = TRUE, cache = drake::get_cache(path =
  path, search = search, verbose = verbose), verbose = 1L,
  upstream_only = NULL)
}
\arguments{
\item{path}{Root directory of the drake project,
or if \code{search} is \code{TRUE}, either the
project root or a subdirectory of the project.
Ignored if a \code{cache} is supplied.}

\item{search}{Logical. If \code{TRUE}, search parent directories
to find the nearest drake cache. Otherwise, look in the
current working directory only.
Ignored if a \code{cache} is supplied.}

\item{cache}{drake cache. See \code{\link[=new_cache]{new_cache()}}.
If supplied, \code{path} and \code{search} are ignored.}

\item{verbose}{Logical or numeric, control printing to the console.
\itemize{
\item \code{0} or \code{FALSE}: print nothing.
\item \code{1} or \code{TRUE}: print only targets to build.
\item \code{2}: plus checks and cache info.
\item \code{3}: plus missing imports.
\item \code{4}: plus all imports.
\item \code{5}: plus execution and total build times for targets.
\item \code{6}: plus notifications when targets are being stored.
}}

\item{upstream_only}{Deprecated.}
}
\value{
A character vector of target names.
}
\description{
Together, functions \code{failed()} and
\code{\link[=diagnose]{diagnose()}} should eliminate the strict need
for ordinary error messages printed to the console.
}
\examples{
\dontrun{
test_with_dir("Quarantine side effects.", {
if (suppressWarnings(require("knitr"))) {
load_mtcars_example() # Get the code with drake_example("mtcars").
make(my_plan) # Run the project, build the targets.
failed() # Should show that no targets failed.
# Build a workflow plan doomed to fail:
bad_plan <- drake_plan(x = function_doesnt_exist())
try(make(bad_plan), silent = TRUE) # error
failed() # "x"
diagnose(x) # Retrieve the cached error log of x.
}
})
}
}
\seealso{
\code{\link[=running]{running()}}, \code{\link[=make]{make()}}
}
