% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initialization.R
\name{FindLogisticGrids}
\alias{FindLogisticGrids}
\title{FindLogisticGrids}
\usage{
FindLogisticGrids(x, y, retheta.init, use.Hessian = FALSE)
}
\arguments{
\item{x}{Vector of doses.}

\item{y}{Vector of responses.}

\item{retheta.init}{Parameters of a 4PL model among which the EC50 parameter is
in the log 10 dose scale.}

\item{use.Hessian}{Indicator of whether the Hessian matrix (TRUE) or the
gradient vector is used in confidence interval computation.}
}
\value{
Data frame whose first column represents the grid on the upper asymptote
parameter and second column represents the grid o the lower asymptote.
}
\description{
Compute the grids on the upper and lower asymptote parameters for the logistic
method based on initial parameter estimates and data.
}
\details{
This function computes the grids on the upper and lower asymptote
parameters based on initial parameter
estimates and data. It basically computes the confidence intervals of the
true parameters based on the variance-covariance matrix of the given initial
parameter estimates. If matrix inversion of the variance-covariance matrix
is infeasible, a variation of the method in Wang et al. (2010) is used.
}
\references{
\insertRef{Wang2010}{dr4pl}
}
\seealso{
\code{FindHillBounds}, \code{FindInitialParms}
}
\author{
Hyowon An
}
