% Generated by roxygen2 (4.0.2): do not edit by hand
\name{setops}
\alias{intersect}
\alias{setdiff}
\alias{setequal}
\alias{setops}
\alias{union}
\title{Set operations.}
\usage{
intersect(x, y, ...)

union(x, y, ...)

setdiff(x, y, ...)

setequal(x, y, ...)
}
\arguments{
\item{x,y}{objects to compare (ignoring order)}

\item{...}{other arguments passed on to methods}
}
\description{
These functions override the set functions provided in base to make them
generic so that efficient versions for data frames and other tables can be
provided. The default methods call the base versions.
}
\examples{
mtcars$model <- rownames(mtcars)
first <- mtcars[1:20, ]
second <- mtcars[10:32, ]

intersect(first, second)
union(first, second)
setdiff(first, second)
setdiff(second, first)

setequal(mtcars, mtcars[32:1, ])
}

