% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/series_bootstrapped.R
\name{series.bootstrap}
\alias{series.bootstrap}
\title{Series bootstrap}
\usage{
series.bootstrap(data.boot, stat, R, names.stat, aver.by.tree.input)
}
\arguments{
\item{data.boot}{Data matrix containing standardized ring width indices from which the bootstrapped replicates are calculated.}

\item{stat}{A function giving the statistics that are to be calculated}

\item{R}{The number of bootstrapped replicates}

\item{names.stat}{the names of the statistics contained in function "stat"}

\item{aver.by.tree.input}{This is a True/False. If True then averages tree series, then average tree means. If False then average all series}
}
\value{
\item{org.stat}{The original input statistics}
\item{boot.stat}{The statistics of the bootstrapped replicates, c('mean','median')}
\item{bias}{The bias of the boot.stat}
\item{std.error}{The standard error of boot.stat}
\item{boot.series.mean}{The bootstrapped replicates mean series}
\item{boot.series.std}{The bootstrapped replicates standard deviation series}
}
\description{
This function calculate the bootstrapped replicated series for calculating concordance
}
\examples{
\dontrun{#Subset "near-pith" is the material within 0 -20cm from the estimated pith
spline200.sub0.20.n   <- TruncSeriesPithoffset( ring.raw, ring.stand, dbh.po.nc, c(1,200))
boot.0.20   <-  series.bootstrap( spline200.sub0.20.n$sub.series.stand, stat, 999,
   names.stat, aver.by.tree = FALSE)}
}

