% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/overall.concordance.period.r
\name{overall.concordance.period}
\alias{overall.concordance.period}
\title{Overall Concordance period}
\usage{
overall.concordance.period(x, y, x.boot, y.boot, min.series,
  concordance.indices, period, trim.alpha = 0, concordance.beta = 0.5)
}
\arguments{
\item{x}{A matrix containing the standardized ring width indices for subset X, column heading tree ID,  row names is time}

\item{y}{As x, but for subset Y}

\item{x.boot}{the bootstrapped replicates for matrix x. with bootstrapped replicate as row names, and time as the column headings}

\item{y.boot}{the bootstrapped replicates for matrix y.}

\item{min.series}{is a number indicating the minimum number of series for calculating the concordance statistic, recommend 10.}

\item{concordance.indices}{The function used for calculating the concordance indices for each t.}

\item{period}{Time period for which the concordance is to be calculated, vector of form c(start, end)}

\item{trim.alpha}{this is the amount of trimming of the extreme concordance indices, default is 0 (no trimming). Recommend that a 0.005 be used.}

\item{concordance.beta}{This is used to calculated the proportion of indices above this cut off. Default is proportion above 0.5.}
}
\value{
\item{pre.in}{Concordance indices.}
\item{min.series}{Minimum number of series used to calculate concordance.}
\item{num.series.at.t.x}{Number of series in matrix X for each time, t.}
\item{num.series.at.t.y}{Number of series in matrix Y for each time, t.}
\item{pre.in.greater.ts.period}{Concordance indices, as time series, when minimum number of series was available.}
\item{period}{The time period used to calculate the concordance.}
\item{pre.overall.period}{The Concordance Statistic.}
}
\description{
Produces the concordance indices for each year over the period of interest and the average of these indices. Trimmed and different levels of concordance indices in the overall concordance, size adjusted (mean concordance indices)
}
\examples{
#loading data
\dontrun{
data(ring.raw)
data(ring.stand)
data(dbh.po.nc)

#Subset near-pith is the material within 0 -20cm from the estimated pith
spline200.sub0.20.n   <- TruncSeriesPithoffset( ring.raw, ring.stand, dbh.po.nc, c(1,200))
# Subset far-pith is the material further than 20cm from the estimated pith
spline200.sub20.2000.n  <- TruncSeriesPithoffset( ring.raw, ring.stand, dbh.po.nc, c(200,200000))

# series.bootstapped
boot.0.20   <-  series.bootstrap( spline200.sub0.20.n$sub.series.stand,
   stat, 999, names.stat, aver.by.tree = FALSE)
boot.20.2000   <- series.bootstrap(spline200.sub20.2000.n$sub.series.stand,
   stat, 999, names.stat, aver.by.tree = FALSE)

overall.precision.HUP <- overall.concordance.period(spline200.sub20.2000.n$sub.series.stand ,
   spline200.sub0.20.n$sub.series.stand,
   boot.20.2000$boot.series.mean,  boot.0.20$boot.series.mean ,
   1 , concordance.indices, c(1880,1999), trim.alpha=0.005, concordance.beta=0.5)
}
}

