% Generated by roxygen2 (4.0.2): do not edit by hand
\docType{class}
\name{adpcr-class}
\alias{adpcr}
\alias{adpcr-class}
\title{Class \code{"adpcr"} - end-point array digital PCR experiments}
\description{
A class specifically designed to contain results from end-point array
digital PCR experiments. Data is represented as matrix, where each column
describes different experiment. Type of data in all columns is specified in
slot \code{"type"}.
}
\details{
Possible \code{type} values of \code{adpcr} objects:
\enumerate{
 \item{\code{"ct"}: cycle threshold of each well,}
 \item{\code{"fluo"}: fluorescence of each well,}
 \item{\code{"nm"}: number of molecules in each well,}
 \item{\code{"np"}: status (positive (1) or negative(0)) of each well,}
 \item{\code{"tnp"}: total number of positive wells in the panel (single value per each
 panel, not per well).}}
}
\section{Slots}{

\describe{
\item{\code{.Data}}{\code{"matrix"} containing data from array. See Description.}

\item{\code{n}}{Object of class \code{"integer"} equal to the number of wells in each
experiment.}

\item{\code{breaks}}{\code{"numeric"} vector giving the number of intervals into which
\code{.Data} should be cut. The second element in \code{breaks} vector is considered
a threshold. Partition above or equal to threshold is counted as
positive.}

\item{\code{type}}{Object of class \code{"character"} defining type of data. See Details.}
}}
\examples{
rand_array <- sim_adpcr(400, 1600, 100, pos_sums = FALSE, n_panels = 5)
one_rand_array <- extract_dpcr(rand_array, 1)
plot_panel(one_rand_array, 40, 40)
}
\author{
Michal Burdukiewicz.
}
\seealso{
Ploting and management: \code{\link{bind_dpcr}},
\code{\link{extract_dpcr}}, \code{\link{plot_panel}}.

Tests: \code{\link{test_panel}}.

Simulation: \code{\link{sim_adpcr}}.

Real-time array digital PCR: \code{\linkS4class{rtadpcr}}.

Droplet digital PCR: \code{\linkS4class{ddpcr}}.
}
\keyword{classes}

