% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-conversion.R
\name{igraph_to_dodgr}
\alias{igraph_to_dodgr}
\title{igraph_to_dodgr}
\usage{
igraph_to_dodgr(graph)
}
\arguments{
\item{graph}{An \pkg{igraph} network}
}
\value{
The \code{dodgr} equivalent of the input.
}
\description{
Convert a \pkg{igraph} network to an equivalent \code{dodgr} representation.
}
\examples{
graph <- weight_streetnet (hampi)
graphi <- dodgr_to_igraph (graph)
graph2 <- igraph_to_dodgr (graphi)
identical (graph2, graph) # FALSE
}
\seealso{
\link{dodgr_to_igraph}

Other conversion: 
\code{\link{dodgr_deduplicate_graph}()},
\code{\link{dodgr_to_igraph}()},
\code{\link{dodgr_to_sfc}()},
\code{\link{dodgr_to_sf}()},
\code{\link{dodgr_to_tidygraph}()}
}
\concept{conversion}
