% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph-functions.R
\name{dodgr_vertices}
\alias{dodgr_vertices}
\title{dodgr_vertices}
\usage{
dodgr_vertices(graph)
}
\arguments{
\item{graph}{A flat table of graph edges. Must contain columns labelled
\code{from} and \code{to}, or \code{start} and \code{stop}. May also contain
similarly labelled columns of spatial coordinates (for example
\code{from_x}) or \code{stop_lon}).}
}
\value{
A \code{data.frame} of vertices with unique numbers (\code{n}).
}
\description{
Extract vertices of graph, including spatial coordinates if included
}
\note{
Values of \code{n} are 0-indexed
}
\examples{
graph <- weight_streetnet (hampi)
v <- dodgr_vertices (graph)
}
\seealso{
Other misc: 
\code{\link{compare_heaps}()},
\code{\link{dodgr_flowmap}()},
\code{\link{dodgr_full_cycles}()},
\code{\link{dodgr_fundamental_cycles}()},
\code{\link{dodgr_insert_vertex}()},
\code{\link{dodgr_sample}()},
\code{\link{dodgr_sflines_to_poly}()},
\code{\link{merge_directed_graph}()},
\code{\link{summary.dodgr_dists_categorical}()},
\code{\link{write_dodgr_wt_profile}()}
}
\concept{misc}
