% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/match-points.R
\name{match_pts_to_graph}
\alias{match_pts_to_graph}
\title{match_pts_to_graph}
\usage{
match_pts_to_graph(graph, xy, connected = FALSE)
}
\arguments{
\item{graph}{A \code{dodgr} graph with spatial coordinates, such as a
\code{dodgr_streetnet} object.}

\item{xy}{coordinates of points to be matched to the vertices, either as
matrix or \pkg{sf}-formatted \code{data.frame}.}

\item{connected}{Should points be matched to the same (largest) connected
component of graph? If \code{FALSE} and these points are to be used for a
\code{dodgr} routing routine (\link{dodgr_dists}, \link{dodgr_paths}, or
\link{dodgr_flows_aggregate}), then results may not be returned if points are
not part of the same connected component. On the other hand, forcing them to
be part of the same connected component may decrease the spatial accuracy of
matching.}
}
\value{
A vector index matching the \code{xy} coordinates to nearest edges. For
bi-directional edges, only one match is returned, and it is up to the user to
identify and suitably process matching edge pairs.
}
\description{
Match spatial points to the edges of a spatial graph, through finding the
edge with the closest perpendicular intersection. NOTE: Intersections are
calculated geometrically, and presume planar geometry. It is up to users of
projected geometrical data, such as those within a \code{dodgr_streetnet} object,
to ensure that either: (i) Data span an sufficiently small area that errors
from presuming planar geometry may be ignored; or (ii) Data are re-projected
to an equivalent planar geometry prior to calling this routine.
}
\examples{
graph <- weight_streetnet (hampi, wt_profile = "foot")
# Then generate some random points to match to graph
verts <- dodgr_vertices (graph)
npts <- 10
xy <- data.frame (
    x = min (verts$x) + runif (npts) * diff (range (verts$x)),
    y = min (verts$y) + runif (npts) * diff (range (verts$y))
)
edges <- match_pts_to_graph (graph, xy)
graph [edges, ] # The edges of the graph closest to `xy`
}
\seealso{
Other match: 
\code{\link{add_nodes_to_graph}()},
\code{\link{match_points_to_graph}()},
\code{\link{match_points_to_verts}()},
\code{\link{match_pts_to_verts}()}
}
\concept{match}
