% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{numDerivLogf}
\alias{numDerivLogf}
\alias{numDerivLogf}
\alias{numDeriv2Logf}
\title{Build Derivative Function for Log f}
\usage{
numDerivLogf(f, isLogf = FALSE, logZero = .Machine$double.xmin,
  logInf = .Machine$double.xmax/2, method = "Richardson", side = NULL,
  method.args = list())

numDeriv2Logf(f, isLogf = FALSE, logZero = .Machine$double.xmin,
  logInf = .Machine$double.xmax/2, method = "Richardson",
  method.args = list())
}
\arguments{
\item{f}{\code{function(y, theta, ...)}, where \code{theta} is a list of parameters.
A joint probability density function.}

\item{isLogf}{set to \code{TRUE} if \code{f} is already \code{log(f)}.}

\item{logZero}{the value \code{log(f)} should return if \code{f} evaluates to \code{0}.}

\item{logInf}{the value \code{log(f)} should return if \code{f} evaluates to \code{Inf}.}

\item{method, side, method.args}{see \code{\link[numDeriv]{grad}} and \code{\link[numDeriv]{hessian}} in package \pkg{numDeriv}.}
}
\value{
\code{numDerivLogf} returns \code{function(y, theta, i, ...)} which evaluates to the first derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]}.

\code{numDeriv2Logf} returns \code{function(y, theta, i, j, ...)} which evaluates to the second derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]} and \code{theta[[j]]}.
}
\description{
\code{numDerivLogf}/\code{numDeriv2Logf} builds a function that evaluates to the first/second derivative of \code{log(f(y, theta, ...))} with respect to \code{theta[[i]]}/\code{theta[[i]]} and \code{theta[[j]]}.
}
\details{
\pkg{numDeriv} produces \code{NaN}s if the log evaluates to (negative) \code{Inf} so you may want to specify \code{logZero} and \code{logInf}.

\code{numDerivLogf} passes \code{method}, \code{side} and \code{method.args} directly to \code{numDeriv::grad}.

\code{numDeriv2Logf} duplicates the internals of \code{numDeriv::hessian} to gain speed.
The defaults for \code{method.args} are \code{list(eps=1e-4, d=0.1, zero.tol=sqrt(.Machine$double.eps/7e-7), r=4, v=2)}.
}
\examples{
## see examples for param

}
\seealso{
\code{\link[numDeriv]{grad}} and \code{\link[numDeriv]{hessian}} in package \pkg{numDeriv}, \code{\link{buildf}}, \code{\link{DerivLogf}}, \code{\link{fisherI}}
}
