% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paragraph2vec.R
\name{as.matrix.paragraph2vec}
\alias{as.matrix.paragraph2vec}
\title{Get the document or word vectors of a paragraph2vec model}
\usage{
\method{as.matrix}{paragraph2vec}(
  x,
  which = c("docs", "words"),
  normalize = TRUE,
  encoding = "UTF-8",
  ...
)
}
\arguments{
\item{x}{a paragraph2vec model as returned by \code{\link{paragraph2vec}} or \code{\link{read.paragraph2vec}}}

\item{which}{either one of 'docs' or 'words'}

\item{normalize}{logical indicating to normalize the embeddings. Defaults to \code{TRUE}.}

\item{encoding}{set the encoding of the row names to the specified encoding. Defaults to 'UTF-8'.}

\item{...}{not used}
}
\value{
a matrix with the document or word vectors where the rownames are the documents or words upon which the model was trained
}
\description{
Get the document or word vectors of a paragraph2vec model as a dense matrix.
}
\examples{
\dontshow{if(require(tokenizers.bpe) & require(udpipe))\{}
library(tokenizers.bpe)
library(udpipe)
data(belgium_parliament, package = "tokenizers.bpe")
x <- subset(belgium_parliament, language \%in\% "french")
x <- subset(x, nchar(text) > 0 & txt_count(text, pattern = " ") < 1000)

model <- paragraph2vec(x = x, type = "PV-DM",   dim = 15,  iter = 5)
\donttest{
model <- paragraph2vec(x = x, type = "PV-DBOW", dim = 100, iter = 20)
}

embedding <- as.matrix(model, which = "docs")
embedding <- as.matrix(model, which = "words")
embedding <- as.matrix(model, which = "docs", normalize = FALSE)
embedding <- as.matrix(model, which = "words", normalize = FALSE)
\dontshow{\} # End of main if statement running only if the required packages are installed}
}
\seealso{
\code{\link{paragraph2vec}}, \code{\link{read.paragraph2vec}}
}
