% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_categorical.R
\name{table_categorical}
\alias{table_categorical}
\title{Display table with comparison of the partition with categorical variables.}
\usage{
table_categorical(
  data,
  partition.name,
  vars.cat,
  vars.cat.names = NULL,
  na.value = "",
  nb.dec = 1,
  text.pval = FALSE
)
}
\arguments{
\item{data}{The dataset.}

\item{partition.name}{string. Name of the partition (in data). The partition
variable should be a factor.}

\item{vars.cat}{vector of strings. variables to compare to (categorical
only).}

\item{vars.cat.names}{Optional. Names for displaying the categorical
variables. (in the same order than \code{vars.cat})}

\item{na.value}{Value to use for the empty cases (e.g. \code{""} or
\code{NA}).}

\item{nb.dec}{digit. Number of decimals for the percentage.}

\item{text.pval}{boolean. Set to \code{TRUE}to display \code{"p="}, to
\code{FALSE} to display only the value.}
}
\value{
table with n and percentage values per level of the partition and
chi square test p-values.
}
\description{
Display table with comparison of the partition with categorical variables.
}
\examples{
data(cancer, package = "survival")
cancer$status <- factor(cancer$status)
table_categorical(data = cancer, partition.name = "status",
                  vars.cat = c("sex", "ph.ecog"))
}
