% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluate_partition_semisup.R
\name{evaluate_partition_semisup}
\alias{evaluate_partition_semisup}
\title{Evaluation of a semisupervised obtained partition in comparison to reference
partitions}
\usage{
evaluate_partition_semisup(
  partition,
  ref.unsup,
  ref.sup,
  ref.semisup,
  data.surv,
  TMIN = 2,
  TMAX = 5
)
}
\arguments{
\item{partition}{Vector containing cluster ids of the partition to evaluate.}

\item{ref.unsup}{Vector: Unsupervised reference partition (i.e. data
structure).}

\item{ref.sup}{Vector: Supervised reference partition (i.e. using survival
parameters).}

\item{ref.semisup}{Vector: Semisupervised reference partition (i.e. combining
both).}

\item{data.surv}{dataframe with variables \code{time} and \code{status}.}

\item{TMIN}{time point to start analyzing AUC.}

\item{TMAX}{time point to analyze AUC.}
}
\value{
a list of named performances values
}
\description{
Evaluate number of clusters, ARI, AUC difference, c-index and CPE, with
Supervised, unsupervised and Semisupervised reference  partitions
}
\examples{
library(survival) # survival should be loaded in the environment
data(cancer, package = "survival")
cancer$status <- cancer$status - 1
res <- evaluate_partition_semisup (
  partition = factor(rep(c(1,2,3), each = 50)),
  ref.unsup = factor(rep(c(1,2,3), times = c(100, 25, 25))),
  ref.sup = factor(rep(c(1,2), times = c(50, 100))),
  ref.semisup = factor(rep(c(3, 2, 1), times = c(120, 10, 20))),
  data.surv = cancer[1:150, c("time", "status")] )
}
