% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/by-lmBy.R
\name{by-lmby}
\alias{by-lmby}
\alias{lm_by}
\alias{lmBy}
\alias{coef.lmBy}
\alias{coef.summary_lmBy}
\alias{summary.lmBy}
\alias{fitted.lmBy}
\alias{residuals.lmBy}
\alias{getBy}
\title{List of lm objects with a common model}
\usage{
lm_by(data, formula, id = NULL, ...)

lmBy(formula, data, id = NULL, ...)
}
\arguments{
\item{data}{A dataframe}

\item{formula}{A linear model formula object of the form
\code{y ~ x1 + ... + xn | g1 + ... + gm}.  In the formula object, \code{y} represents
the response, \verb{x1, ..., xn} the covariates, and the grouping
factors specifying the partitioning of the data according to
which different lm fits should be performed.}

\item{id}{A formula describing variables from data which are to be
available also in the output.}

\item{\dots}{Additional arguments passed on to \code{lm()}.}
}
\value{
A list of lm fits.
}
\description{
The data is split into strata according to the levels
of the grouping factors and individual lm fits are obtained for
each stratum.
}
\examples{

bb <- lmBy(1 / uptake ~ log(conc) | Treatment, data=CO2)
coef(bb)

fitted(bb)
residuals(bb)

summary(bb)
coef(summary(bb))
coef(summary(bb), simplify=TRUE)
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk}
}
\keyword{models}
