% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BY-orderBy.R
\name{by-order}
\alias{by-order}
\alias{orderBy}
\title{Ordering (sorting) rows of a data frame}
\usage{
orderBy(formula, data)
}
\arguments{
\item{formula}{The right hand side of a formula}

\item{data}{A dataframe}
}
\value{
The ordered data frame
}
\description{
Ordering (sorting) rows of a data frame by the certain
    variables in the data frame. This function is essentially a
    wrapper for the \code{order()} function - the important
    difference being that variables to order by can be given by a
    model formula.
}
\details{
The sign of the terms in the formula determines whether
    sorting should be ascending or decreasing; see examples below
}
\examples{

orderBy(~ conc + Treatment, CO2)
## Sort decreasingly by conc
orderBy(~ - conc + Treatment, CO2)
}
\seealso{
\code{\link{transformBy}}, \code{\link{splitBy}}
}
\author{
Søren Højsgaard, \email{sorenh@math.aau.dk} and Kevin
    Wright
}
\keyword{utilities}
