### R code from vignette source 'popMeans.Rnw'

###################################################
### code chunk number 1: popMeans.Rnw:30-33
###################################################
require( doBy )
prettyVersion <- packageDescription("doBy")$Version
prettyDate <- format(Sys.Date())


###################################################
### code chunk number 2: popMeans.Rnw:68-74
###################################################
library(doBy)
dd <- expand.grid(A=factor(1:3),B=factor(1:3),C=factor(1:2))
dd$y <- rnorm(nrow(dd))
dd$x <- rnorm(nrow(dd))^2
dd$z <- rnorm(nrow(dd))
head(dd,10)


###################################################
### code chunk number 3: popMeans.Rnw:85-87
###################################################
mm <- lm(y~A+B+C, data=dd)
coef(mm)


###################################################
### code chunk number 4: popMeans.Rnw:110-112
###################################################
w <- c(0,-1,1,0,0,0)
sum(coef(mm)*w)


###################################################
### code chunk number 5: popMeans.Rnw:118-119
###################################################
esticon(mm, w)


###################################################
### code chunk number 6: popMeans.Rnw:169-172
###################################################
w <- c(1, 0, 0, 1/3, 1/3, 1/2)
coef(mm)*w
sum(coef(mm)*w)


###################################################
### code chunk number 7: popMeans.Rnw:178-183
###################################################
W <- matrix(c(1, 0, 0, 1/3, 1/3, 1/2,
              1, 1, 0, 1/3, 1/3, 1/2,
              1, 0, 1, 1/3, 1/3, 1/2),nr=3, byrow=TRUE)
W
W %*% coef(mm)


###################################################
### code chunk number 8: popMeans.Rnw:198-199
###################################################
esticon(mm, W)


###################################################
### code chunk number 9: popMeans.Rnw:212-214
###################################################
pma <- popMatrix(mm,effect='A')
summary(pma)


###################################################
### code chunk number 10: popMeans.Rnw:222-224
###################################################
pme <- popMeans(mm, effect='A')
pme


###################################################
### code chunk number 11: popMeans.Rnw:230-231
###################################################
summary(pme)


###################################################
### code chunk number 12: popMeans.Rnw:241-242
###################################################
popMatrix(mm,effect=c('A','C'))


###################################################
### code chunk number 13: popMeans.Rnw:248-249
###################################################
popMeans(mm)


###################################################
### code chunk number 14: popMeans.Rnw:260-261
###################################################
popMatrix(mm,effect='A', at=list(C='1'))


###################################################
### code chunk number 15: popMeans.Rnw:266-267
###################################################
popMatrix(mm,effect='A', at=list(C=c('1','2')))


###################################################
### code chunk number 16: popMeans.Rnw:273-274
###################################################
popMatrix(mm,effect='A', at=list(C=c('1','2'), B='1'))


###################################################
### code chunk number 17: popMeans.Rnw:283-284
###################################################
popMatrix(mm,effect=c('A','C'), at=list(C='1'))


###################################################
### code chunk number 18: popMeans.Rnw:295-296 (eval = FALSE)
###################################################
## popMatrix(mm,effect='A', at=list(C='1'))


###################################################
### code chunk number 19: popMeans.Rnw:303-305
###################################################
mm2 <- lm(y~A+B+C+C:x, data=dd)
coef(mm2)


###################################################
### code chunk number 20: popMeans.Rnw:309-310
###################################################
popMatrix(mm2,effect='A', at=list(C='1'))


###################################################
### code chunk number 21: popMeans.Rnw:317-318
###################################################
popMatrix(mm2,effect='A', at=list(C='1',x=12))


###################################################
### code chunk number 22: popMeans.Rnw:326-328
###################################################
mm3 <- lm(y~A+B+C+C:log(x), data=dd)
coef(mm3)


###################################################
### code chunk number 23: popMeans.Rnw:336-339
###################################################
dd <- transform(dd, log.x = log(x))
mm3 <- lm(y~A+B+C+C:log.x, data=dd)
popMatrix(mm3,effect='A', at=list(C='1'))


###################################################
### code chunk number 24: popMeans.Rnw:355-358
###################################################
 library(multcomp)
g<-popMeans(mm,effect='A', at=list(C='1'),engine="glht")
g


###################################################
### code chunk number 25: popMeans.Rnw:362-364
###################################################
summary(g,test=univariate())
confint(g,calpha=univariate_calpha())


###################################################
### code chunk number 26: popMeans.Rnw:369-371
###################################################
summary(g)
confint(g)


