% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/join.R
\name{join}
\alias{join}
\alias{join_inner}
\alias{join_full}
\alias{join_left}
\alias{join_right}
\alias{join_out}
\title{Join two dataframes together}
\usage{
join_inner(x, y, by = NULL)

join_full(x, y, by = NULL)

join_left(x, y, by = NULL)

join_right(x, y, by = NULL)

join_out(x, y, by = NULL)
}
\arguments{
\item{x}{one dataframe}

\item{y}{the other dataframe}

\item{by}{the id name in x and y dataframe}
}
\value{
one joined dataframe.
}
\description{
Join two dataframes by the same id column.
}
\details{
join_inner(), join_full(), join_left(), join_right() and join_out() are five
    functons to joint two dataframes together. They are based on package 'data.table', 
    so they are more efficient and fast.
}
\examples{
df1=data.frame(x=rep(c('b','a','c'),each=3),
              y=c(1,3,6),
              v=1:9)

df2=data.frame(x=c('c','b','e'),
               v=8:6,
               foo=c(4,2,1))
join_inner(df1,df2,'x')
join_full(df1,df2,'x')
join_left(df1,df2,'x')
join_right(df1,df2,'x')
join_out(df1,df2,'x')
}
