% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rename.R
\name{rename_dataset}
\alias{rename_dataset}
\title{For rename dataset}
\usage{
rename_dataset(
  dataset,
  path_crfs,
  no_readable_name,
  readable_name,
  num_sheet = 1,
  is_post = T
)
}
\arguments{
\item{dataset}{A dataset, a type is a data frame.}

\item{path_crfs}{A character scalar. Path to the specification files the in excel table.}

\item{no_readable_name}{A character scalar. A column name of no_readable values.}

\item{readable_name}{A character scalar. A column name of readable values.}

\item{num_sheet}{An integer scalar, default is the first sheet. A position of a sheet in the excel document.}

\item{is_post}{A logical scalar, default is TRUE. True is postfix, otherwise, prefix.}
}
\value{
The list with two values: data - renamed dataset, spec - common specification.
        The common specification is data frame of two values: no_readable_var, readable_var.
}
\description{
For rename dataset
}
\examples{
id <- c("01", "02", "03")
age <- c("19", "20", "22")
sex <- c("f", "m", "f")
bio_date_post <- c("1991-03-23", "1991-03-16", "1991-03-16")
gluc_post <- c("5.5", "4.1", "9.7")
gluc_res_post <- c("norm", "no", "norm")


df <- data.frame(
  id, age, sex,
  bio_date_post,
  gluc_post, gluc_res_post,
  stringsAsFactors = FALSE
)

crfs <- system.file("forms", package = "dmtools")

result <- rename_dataset(df, crfs, "old_name", "new_name")
result[["data"]]

}
