% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MeasEquiv_EffectSize_Wrappers.R
\name{dmacs_summary}
\alias{dmacs_summary}
\title{Summary of measurement nonequivalence effects}
\usage{
dmacs_summary(LambdaList, ThreshList, MeanList, VarList, SDList,
  Groups = NULL, RefGroup = 1, categorical = FALSE, ...)
}
\arguments{
\item{LambdaList}{is a list, indexed by groups, of factor loading
matrices (dataframes are allowed).}

\item{ThreshList}{is a list, indexed by groups, of vectors of indicator
intercepts (for continuous indicators) or lists, indexed by items, of
vectors of thresholds (for categorical indicators). For categorical
indicators, do \strong{not} provide a matrix of thresholds for each group.}

\item{MeanList}{is a list, indexed by groups, of vectors of factor means.
For unidimensional models, this is simply a list of factor means.}

\item{VarList}{is a list, indexed by groups, of vectors of factor variances.
For unidimensional models, this is simply a list of factor variances.}

\item{SDList}{is a list, indexed by groups, of vectors of indicator
observed standard deviations used as the denominator of the dmacs effect
size. This will usually either be pooled standard deviations or the
standard deviation of the reference group. Each group, including the
reference group, must be included in SDList (although the standard
deviations for the reference group are ignored).}

\item{Groups}{is a vector of group names. If no value is provided,
dmacs_summary will try to use \code{names(LambdaList)}; if LambdaList
has no names, then the groups will be numbered.}

\item{RefGroup}{can be the name of the reference group (as a string),
or the index of the reference group (as a number). RefGroup defaults to
the first group if no value is provided. It is strongly recommended to
provide the reference group as a string, since group names in data are
often ordered by their appearance in the data, not alphabetically.}

\item{categorical}{is a Boolean variable declaring whether the variables
in the model are ordered categorical. Models in which some variables are
categorical and others are continuous are not supported. If no value is
provided, categorical defaults to \code{FALSE}, although if multiple
thresholds are provided for an item, categorical will be forced to
\code{TRUE}. A graded response model with probit link (e.g., DWLS in
lavaan or WLSMV in Mplus) is used for categorical variables. If you desire
for other categorical models (e.g., IRT parameterization) to be supported,
e-mail the maintainer.}

\item{...}{other parameters to be used in functions that
\code{dmacs_summary} calls, most likely \code{stepsize} for the
\code{\link{item_dmacs}} and \code{\link{delta_mean_item}} functions.}
}
\value{
A list, indexed by groups, of lists of measurement nonequivalence
effects  from Nye and Drasgow (2011), including dmacs, expected bias in the mean score by item,
expected bias in the mean total score, and expected bias in the variance
of the total score. Expected bias in the variance of the total score is
only supplied for unidimensional models with linear indicators (i.e., not categorical)
in the current version of this package.
}
\description{
\code{dmacs_summary} returns a summary of measurement non-equivalence
effects given lists of parameters.
}
\details{
\code{dmacs_summary} is called by \code{\link{lavaan_dmacs}} and
\code{\link{mplus_dmacs}}, which are the only functions in this
package intended for casual users
}
\section{References}{

Nye, C. & Drasgow, F. (2011). Effect size indices for analyses of
measurement equivalence: Understanding the practical importance of
differences between groups. \emph{Journal of Applied Psychology, 96}(5),
966-980.
}

\examples{
LambdaList <- list(Group1 <- matrix(c(1.00, 0.74,  1.14, 0.92), ncol = 1),
                   Group2 <- matrix(c(1.00, 0.76,  1.31, 0.98), ncol = 1))
ThreshList <- list(Group1 <- c(0.00, 1.28, -0.82, 0.44),
                   Group2 <- c(0.00, 0.65, -0.77, 0.47))
MeanList   <- list(Group1 <- 0.21,
                   Group2 <- 0.19)
VarList    <- list(Group1 <- 1.76,
                   Group2 <- 1.34)
SDList     <- list(Group1 <- c(2.12, 1.85,  1.12, 3.61),
                   Group2 <- c(NA, NA, NA, NA))
Groups <- c("Group1", "Group2")
RefGroup <- "Group2"
dmacs_summary(LambdaList, ThreshList, MeanList, VarList, SDList,
              Groups, RefGroup)

}
