% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/missing.R
\name{plot_na_hclust}
\alias{plot_na_hclust}
\title{Combination chart for missing value}
\usage{
plot_na_hclust(
  x,
  main = NULL,
  col.left = "#009E73",
  col.right = "#56B4E9",
  typographic = TRUE,
  base_family = NULL
)
}
\arguments{
\item{x}{data frames, or objects to be coerced to one.}

\item{main}{character. Main title.}

\item{col.left}{character. The color of left legend that is frequency of NA. default is "#009E73".}

\item{col.right}{character. The color of right legend that is percentage of NA. default is "#56B4E9".}

\item{typographic}{logical. Whether to apply focuses on typographic elements to ggplot2 visualization. 
The default is TRUE. if TRUE provides a base theme that focuses on typographic elements using hrbrthemes package.}

\item{base_family}{character. The name of the base font family to use 
for the visualization. If not specified, the font defined in dlookr is applied. (See details)}
}
\description{
Visualize distribution of missing value by combination of variables.
}
\details{
Rows are variables containing missing values, and columns are observations. 
These data structures were grouped into similar groups by applying hclust. 
So, it was made possible to visually examine how the missing values are distributed 
for each combination of variables.

The base_family is selected from "Roboto Condensed", "Liberation Sans Narrow",
"NanumSquare", "Noto Sans Korean". If you want to use a different font, 
use it after loading the Google font with import_google_font().
}
\examples{
# Generate data for the example
set.seed(123L)
jobchange2 <- jobchange[sample(nrow(jobchange), size = 1000), ]

# Visualize hcluster chart for variables with missing value.
plot_na_hclust(jobchange2)

# Change the main title.
# plot_na_hclust(jobchange2, main = "Distribution of missing value")

# Not support typographic elements
# plot_na_hclust(jobchange2, typographic = FALSE)

}
