% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classes.R
\docType{class}
\name{epid-class}
\alias{epid-class}
\alias{is.epid}
\alias{as.epid}
\alias{format.epid}
\alias{unique.epid}
\alias{summary.epid}
\alias{print.epid_summary}
\alias{as.data.frame.epid}
\alias{as.list.epid}
\alias{show,epid-method}
\alias{rep,epid-method}
\alias{[,epid-method}
\alias{[[,epid-method}
\alias{c,epid-method}
\title{\code{epid} object}
\usage{
is.epid(x)

as.epid(x)

\method{format}{epid}(x, ...)

\method{unique}{epid}(x, ...)

\method{summary}{epid}(object, ...)

\method{print}{epid_summary}(x, ...)

\method{as.data.frame}{epid}(x, ...)

\method{as.list}{epid}(x, ...)

\S4method{show}{epid}(object)

\S4method{rep}{epid}(x, ...)

\S4method{[}{epid}(x, i, j, ..., drop = TRUE)

\S4method{[[}{epid}(x, i, j, ..., exact = TRUE)

\S4method{c}{epid}(x, ...)
}
\arguments{
\item{x}{x}

\item{...}{...}

\item{object}{object}

\item{i}{i}

\item{j}{j}

\item{drop}{drop}

\item{exact}{exact}
}
\description{
S4 objects storing the result of \code{\link{episodes}}.
}
\section{Slots}{

\describe{
\item{\code{sn}}{Unique record identifier.}

\item{\code{.Data}}{Unique \code{episode} identifier.}

\item{\code{wind_id}}{Unique window identifier.}

\item{\code{wind_nm}}{Type of window i.e. "Case" or "Recurrence".}

\item{\code{case_nm}}{Record type in regards to case assignment.}

\item{\code{dist_wind_index}}{Unit difference between each record and its window's reference record.}

\item{\code{dist_epid_index}}{Unit difference between each record and its episode's reference record.}

\item{\code{epid_dataset}}{Data sources in each \code{episode}.}

\item{\code{epid_interval}}{The start and end dates of each \code{episode}. A \code{\link{number_line}} object.}

\item{\code{epid_length}}{The duration or length of (\code{epid_interval}).}

\item{\code{epid_total}}{The number of records in each \code{episode}.}

\item{\code{iteration}}{The iteration of the tracking process when a record was linked to its episode.}

\item{\code{options}}{Some options passed to the instance of \code{\link{episodes}}.}
}}

\examples{
# A test for `epid` objects
ep <- episodes(date = 1)
is.epid(ep); is.epid(2)

}
