% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel_clust.R
\name{ds_rel_clust}
\alias{ds_rel_clust}
\alias{rel_clust}
\title{Compute Relative Clustering}
\usage{
ds_rel_clust(.data, .cols, .name)

rel_clust(..., .data = dplyr::cur_data_all())
}
\arguments{
\item{.data}{\link[tibble:tibble-package]{tibble} with sf geometry}

\item{.cols}{\href{https://tidyselect.r-lib.org/reference/language.html}{\code{tidy-select}}
Columns to compute the measure with. Must be at least 2 columns. If more than 2, treats
first column as first group and sum of other columns as second.}

\item{.name}{name for column with relative clustering. Leave missing to return a vector.}

\item{...}{arguments to forward to ds_rel_clust from rel_clust}
}
\value{
a \link[tibble:tibble-package]{tibble} or numeric vector if .name missing
}
\description{
Compute Relative Clustering
}
\examples{
data("de_county")
ds_rel_clust(de_county, c(pop_black, starts_with('pop_')))
ds_rel_clust(de_county, c(pop_black, starts_with('pop_')), 'rel_clust')
}
\concept{clustering}
