% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.R
\name{readDicom}
\alias{readDicom}
\title{Read one or more DICOM directories}
\usage{
readDicom(path, flipY = TRUE, verbosity = 0L)
}
\arguments{
\item{path}{A character vector of paths to scan for DICOM files. Each will
examined in turn.}

\item{flipY}{If \code{TRUE}, the default, then images will be flipped in the
Y-axis. This is usually desirable, given the difference between
orientation conventions in the DICOM and NIfTI-1 formats.}

\item{verbosity}{Integer value between 0 and 3, controlling the amount of
output generated during the conversion.}
}
\value{
A list of \code{niftiImage} objects, which can be easily converted
  to R arrays or written to NIfTI-1 format, using functions from the
  \code{RNifti} package. If the process fails, the result will be
  \code{NULL}.
}
\description{
This function is an R wrapper around the DICOM-to-NIfTI conversion routines
provided by \code{dcm2niix}. It scans directories containing DICOM files,
potentially pertaining to more than one image series, reads them and merges
them into a list of \code{niftiImage} objects.
}
\examples{
path <- system.file("extdata", "testdata", package="divest")
readDicom(path)
}
\author{
Jon Clayden <code@clayden.org>
}

