% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun_similarity.R
\name{fun_similarity}
\alias{fun_similarity}
\title{Functional similarity}
\usage{
fun_similarity(distances, exponential = TRUE, rate = 1, check_arguments = TRUE)
}
\arguments{
\item{distances}{A distance matrix or an object of class \link[stats:dist]{stats::dist}}

\item{exponential}{If \code{TRUE}, similarity is \eqn{e^{-r \delta}},
where \eqn{r} is argument \code{rate}.
If \code{FALSE}, it is \eqn{1 - \delta / \max(\delta)}.}

\item{rate}{The decay rate of the exponential similarity.}

\item{check_arguments}{If \code{TRUE}, the function arguments are verified.
Should be set to \code{FALSE} to save time when the arguments have been checked elsewhere.}
}
\value{
A similarity matrix.
}
\description{
Transform a distance matrix into a similarity matrix
\insertCite{Leinster2012}{divent}.
Similarity between two species is defined either by a negative exponential
function of their distance or by the complement to 1 of their normalized
distance (such that the most distant species are 1 apart).
}
\examples{
# Similarity between Paracou 6 species
hist(fun_similarity(paracou_6_fundist))

}
\references{
\insertAllCited{}
}
