% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Beta.R
\name{pdf.Beta}
\alias{pdf.Beta}
\alias{log_pdf.Beta}
\title{Evaluate the probability mass function of a Beta distribution}
\usage{
\method{pdf}{Beta}(d, x, drop = TRUE, elementwise = NULL, ...)

\method{log_pdf}{Beta}(d, x, drop = TRUE, elementwise = NULL, ...)
}
\arguments{
\item{d}{A \code{Beta} object created by a call to \code{\link[=Beta]{Beta()}}.}

\item{x}{A vector of elements whose probabilities you would like to
determine given the distribution \code{d}.}

\item{drop}{logical. Should the result be simplified to a vector if possible?}

\item{elementwise}{logical. Should each distribution in \code{d} be evaluated
at all elements of \code{x} (\code{elementwise = FALSE}, yielding a matrix)?
Or, if \code{d} and \code{x} have the same length, should the evaluation be
done element by element (\code{elementwise = TRUE}, yielding a vector)? The
default of \code{NULL} means that \code{elementwise = TRUE} is used if the
lengths match and otherwise \code{elementwise = FALSE} is used.}

\item{...}{Arguments to be passed to \code{\link[stats]{dbeta}}.
Unevaluated arguments will generate a warning to catch mispellings or other
possible errors.}
}
\value{
In case of a single distribution object, either a numeric
vector of length \code{probs} (if \code{drop = TRUE}, default) or a \code{matrix} with
\code{length(x)} columns (if \code{drop = FALSE}). In case of a vectorized distribution
object, a matrix with \code{length(x)} columns containing all possible combinations.
}
\description{
Evaluate the probability mass function of a Beta distribution
}
\examples{

set.seed(27)

X <- Beta(1, 2)
X

random(X, 10)

pdf(X, 0.7)
log_pdf(X, 0.7)

cdf(X, 0.7)
quantile(X, 0.7)

mean(X)
variance(X)
skewness(X)
kurtosis(X)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 0.7))
}
