% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Cauchy.R
\name{cdf.Cauchy}
\alias{cdf.Cauchy}
\title{Evaluate the cumulative distribution function of a Cauchy distribution}
\usage{
\method{cdf}{Cauchy}(d, x, ...)
}
\arguments{
\item{d}{A \code{Cauchy} object created by a call to \code{\link[=Cauchy]{Cauchy()}}.}

\item{x}{A vector of elements whose cumulative probabilities you would
like to determine given the distribution \code{d}.}

\item{...}{Unused. Unevaluated arguments will generate a warning to
catch mispellings or other possible errors.}
}
\value{
A vector of probabilities, one for each element of \code{x}.
}
\description{
Evaluate the cumulative distribution function of a Cauchy distribution
}
\examples{

set.seed(27)

X <- Cauchy(10, 0.2)
X

mean(X)
variance(X)
skewness(X)
kurtosis(X)

random(X, 10)

pdf(X, 2)
log_pdf(X, 2)

cdf(X, 2)
quantile(X, 0.7)

cdf(X, quantile(X, 0.7))
quantile(X, cdf(X, 7))
}
