% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsl_handle_NA.R
\name{tsl_handle_NA}
\alias{tsl_handle_NA}
\alias{tsl_Inf_to_NA}
\alias{tsl_NaN_to_NA}
\title{Handle NA Cases in Time Series Lists}
\usage{
tsl_handle_NA(tsl = NULL, na_action = c("impute", "omit"))

tsl_Inf_to_NA(tsl = NULL)

tsl_NaN_to_NA(tsl = NULL)
}
\arguments{
\item{tsl}{(required, list) Time series list. Default: NULL}

\item{na_action}{(required, character) NA handling action. Available options are:
\itemize{
\item "impute" (default): NA cases are interpolated from neighbors as a function of time (see \code{\link[zoo:na.approx]{zoo::na.approx()}} and \code{\link[zoo:na.approx]{zoo::na.spline()}}).
\item "omit": rows with NA cases are removed.
}}
}
\value{
time series list
}
\description{
Removes or imputes NA cases in time series lists. Imputation is done via interpolation against time via \code{\link[zoo:na.approx]{zoo::na.approx()}}, and if there are still leading or trailing NA cases after NA interpolation, then \code{\link[zoo:na.approx]{zoo::na.spline()}} is applied as well to fill these gaps. Interpolated values are forced to fall within the observed data range.

This function supports a parallelization setup via \code{\link[future:plan]{future::plan()}}, and progress bars provided by the package \href{https://CRAN.R-project.org/package=progressr}{progressr}.
}
\examples{

#tsl with NA cases
tsl <- tsl_simulate(
  na_fraction = 0.25
)

tsl_count_NA(tsl = tsl)

if(interactive()){
  #issues warning
  tsl_plot(tsl = tsl)
}

#omit NA (default)
#--------------------------------------

#original row count
tsl_nrow(tsl = tsl)

#remove rows with NA
tsl_no_na <- tsl_handle_NA(
  tsl = tsl,
  na_action = "omit"
)

#count rows again
#large data loss in this case!
tsl_nrow(tsl = tsl_no_na)

#count NA again
tsl_count_NA(tsl = tsl_no_na)

if(interactive()){
  tsl_plot(tsl = tsl_no_na)
}


#impute NA with zoo::na.approx
#--------------------------------------

#impute NA cases
tsl_no_na <- tsl_handle_NA(
  tsl = tsl,
  na_action = "impute"
)

#count rows again
#large data loss in this case!
tsl_nrow(tsl = tsl_no_na)

if(interactive()){
  tsl_plot(tsl = tsl_no_na)
}
}
\seealso{
Other tsl_management: 
\code{\link{tsl_burst}()},
\code{\link{tsl_colnames_clean}()},
\code{\link{tsl_colnames_get}()},
\code{\link{tsl_colnames_prefix}()},
\code{\link{tsl_colnames_set}()},
\code{\link{tsl_colnames_suffix}()},
\code{\link{tsl_count_NA}()},
\code{\link{tsl_diagnose}()},
\code{\link{tsl_join}()},
\code{\link{tsl_names_clean}()},
\code{\link{tsl_names_get}()},
\code{\link{tsl_names_set}()},
\code{\link{tsl_names_test}()},
\code{\link{tsl_ncol}()},
\code{\link{tsl_nrow}()},
\code{\link{tsl_repair}()},
\code{\link{tsl_subset}()},
\code{\link{tsl_time}()},
\code{\link{tsl_to_df}()}
}
\concept{tsl_management}
