% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{permute_restricted_cpp}
\alias{permute_restricted_cpp}
\title{(C++) Restricted Permutation of Cases Within Blocks}
\usage{
permute_restricted_cpp(x, block_size, seed = 1L)
}
\arguments{
\item{x}{(required, numeric matrix). Numeric matrix to permute.}

\item{block_size}{(optional, integer) block size in number of rows.
Minimum value is 2, and maximum value is nrow(x).}

\item{seed}{(optional, integer) random seed to use.}
}
\value{
numeric matrix
}
\description{
Divides a sequence or time series in blocks and permutes cases
within these blocks. This function does not preserve rows, and should not be
used if the sequence has dependent columns.
Larger block sizes increasingly disrupt the data structure over time.
}
\seealso{
Other Rcpp_permutation: 
\code{\link{permute_free_by_row_cpp}()},
\code{\link{permute_free_cpp}()},
\code{\link{permute_restricted_by_row_cpp}()}
}
\concept{Rcpp_permutation}
