% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distance.R
\name{distance}
\alias{distance}
\title{Distance Between Two Numeric Vectors}
\usage{
distance(x = NULL, y = NULL, distance = "euclidean")
}
\arguments{
\item{x}{(required, numeric vector).}

\item{y}{(required, numeric vector) of same length as \code{x}.}

\item{distance}{(optional, character string) name or abbreviation of the distance method. Valid values are in the columns "names" and "abbreviation" of the dataset \code{distances}. Default: "euclidean".}
}
\value{
numeric value
}
\description{
Computes the distance between two numeric vectors with a distance metric included in the data frame \code{distantia::distances}.
}
\examples{

distance(
  x = runif(100),
  y = runif(100),
  distance = "euclidean"
)

}
\seealso{
Other distances: 
\code{\link{distance_matrix}()},
\code{\link{distances}}
}
\concept{distances}
