% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dtt.dispRity.R
\name{dtt.dispRity}
\alias{dtt.dispRity}
\title{dtt dispRity (from \code{geiger::dtt})}
\usage{
dtt.dispRity(
  data,
  metric,
  tree,
  nsim = 0,
  model = "BM",
  alternative = "two-sided",
  scale.time = TRUE,
  ...
)
}
\arguments{
\item{data}{A \code{dispRity} object or a \code{matrix}}

\item{metric}{The disparity metric to be passed to \code{\link{dispRity}}.}

\item{tree}{A \code{phylo} object matching the data and with a \code{root.time} element.}

\item{nsim}{The number of simulations to calculate null disparity-through-time.}

\item{model}{A evolutionary model for the simulations (see \code{\link[geiger]{sim.char}} - default is \code{"BM"}).}

\item{alternative}{The H1 alternative (for calculating the p-value). Can be \code{"two-sided"} (default), \code{"greater"} or \code{"lesser"}; see details.}

\item{scale.time}{Optional, whether to scale the time (between 0 and 1; \code{TRUE}, default) or not (\code{FALSE}).}

\item{...}{Any other arguments to be passed to \code{\link[geiger]{dtt}}.}
}
\description{
A wrapper for the \code{\link[geiger]{dtt}} function working with any disparity metric.
}
\details{
See \code{\link[geiger]{dtt}} for details. Note that for calculating the default metrics implemented in \code{\link[geiger]{dtt}} (i.e \code{c("avg.sq", "avg.manhattan", "num.states")}) this implementation in \code{dispRity} is much slower!
}
\examples{
## Loading geiger's example data set
require(geiger)
geiger_data <- get(data(geospiza))

## Calculate the disparity of the dataset using dtt::geiger
geiger_dtt <- dtt(phy = geiger_data$phy, data = geiger_data$dat, nsim = 100)

## The average squared pairwise distance metric (used in geiger::dtt)
average.sq <- function(X) mean(pairwise.dist(X)^2)

## Calculate the disparity of the dataset using dtt.dispRity
dispRity_dtt <- dtt.dispRity(data = geiger_data$dat, metric = average.sq,
                             tree = geiger_data$phy, nsim = 100)

## Plotting the results
plot(dispRity_dtt)

## Disparity values are identical up to the 9th digit!
round(geiger_dtt$dtt, 9) == round(dispRity_dtt$dtt, 9)
 
## Calculate disparity with a different metric using dtt.dispRity
dispRity_dtt2 <- dtt.dispRity(data = geiger_data$dat, tree = geiger_data$phy,
                             metric = c(median, centroids), nsim = 50)
plot(dispRity_dtt2)

}
\seealso{
\code{\link[geiger]{dtt}}, \code{\link{test.dispRity}}, \code{\link{custom.subsets}}, \code{\link{chrono.subsets}}, \code{\link{plot.dispRity}}.
}
\author{
Thomas Guillerme
}
