% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGraphs.R
\name{plotGraphs}
\alias{plotGraphs}
\title{Plots Graphs using ggplot2 with one attribute}
\usage{
plotGraphs(
  data,
  prop = 20,
  graphmode = "fruchtermanreingold",
  attribute = NULL,
  attribute.label = NULL,
  attribute.node.labels = NULL,
  attribute.nodesize = 10
)
}
\arguments{
\item{data}{Data from the prepareGraphs function}

\item{prop}{Rescaling the graph edge sizes for the plot}

\item{graphmode}{Type of graphical projection to use. Default is Fruchterman Reingold. Refer to gplot.layout for the various available options}

\item{attribute}{Mapping to the attribute information, can be list or column in data frame}

\item{attribute.label}{Name of the attribute info (Required)}

\item{attribute.node.labels}{Mapping to the node labels, can be list or column in data frame}

\item{attribute.nodesize}{Size of the nodes. Default will result in size of 10. Can be replaced with custom mapping in list or column in data frame. (Required)}
}
\description{
Plots graph data using the GGally library and ggnet function while incorporating demographic properties. Use this plot function if you have all demographic data available to plot.
}
\examples{
df <- sampleData1
prepNet <- tabulate_edges(df, iscsvfile = FALSE, silentNodes = 0)
baseNet <- prepareGraphs(prepNet, project_title = "Sample Data 1", weightedGraph = TRUE)
attdata <- attributeData
plotGraphs(baseNet, prop = 20, graphmode = "fruchtermanreingold",
attribute = attdata$gender,
attribute.label = "Gender",
attribute.node.labels = attdata$node, attribute.nodesize = 12)


}
