% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_all.R
\name{run_all}
\alias{run_all}
\title{Run functions in discourseGT in bulk}
\usage{
run_all(
  raw_2col_data,
  project_name = "",
  iscsvfile = TRUE,
  directedNet = TRUE,
  selfInteract = FALSE,
  weightedGraph = TRUE,
  plotGraph = NULL,
  graph_selection_input = 0,
  curvedEdge = TRUE,
  subgroups = NULL,
  normalized = NULL,
  reportResults = NULL,
  displayResults = FALSE
)
}
\arguments{
\item{raw_2col_data}{Data in the raw 2 column format (usually the question and response format)}

\item{project_name}{Name of the project}

\item{iscsvfile}{Sets if the input file is a .csv file or a R data frame object}

\item{directedNet}{Sets the graph directionality}

\item{selfInteract}{Sets the self-interactions permissions}

\item{weightedGraph}{Sets the graph weights}

\item{plotGraph}{Plot the graph data}

\item{graph_selection_input}{Type of graphical projection to use. Default is Fruchterman Reingold. Refer to gplot.layout for the various available options}

\item{curvedEdge}{Whether the edges between nodes should be curved or straight. Default is curved lines.}

\item{subgroups}{Run the subgroups analysis function}

\item{normalized}{Normalize the betweeness centrality values}

\item{reportResults}{Run the summary results of all functions generated, presents in a summary format at end}

\item{displayResults}{Display the summary results of analysis in the console}
}
\value{
Saves output files of the function, plots and text summary, on to the disk. If save option is disabled, function will save results to an data object, if set.
}
\description{
Allows for all or select functions in the discourseGT package to be run at once in bulk and only the very terminus results are stored, plots and text summary. This function is best used for running multiple sets of graphical plots. The function will automatically save the results of the graphs to your disk by default.
}
\examples{
df <- sampleData1
run_all(raw_2col_data = df, project_name = "Sample Data 1", iscsvfile = FALSE,
directedNet = TRUE, selfInteract = FALSE, weightedGraph = TRUE,
plotGraph = TRUE, graph_selection_input = 0, curvedEdge = TRUE,
subgroups = TRUE, normalized = FALSE,
reportResults = TRUE, displayResults = TRUE)

}
