% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parallels-future.R
\name{lapply_async2}
\alias{lapply_async2}
\title{Apply, but in parallel}
\usage{
lapply_async2(
  x,
  FUN,
  FUN.args = list(),
  callback = NULL,
  plan = TRUE,
  future.chunk.size = NULL,
  future.seed = sample.int(1, n = 1e+05 - 1),
  ...
)
}
\arguments{
\item{x}{vector, list}

\item{FUN}{function to apply on each element of \code{x}}

\item{FUN.args}{more arguments to feed into \code{FUN}}

\item{callback}{function to run after each iteration}

\item{plan}{logical, or character or \code{future} plan; see Details.}

\item{future.chunk.size, future.seed}{see also \code{future_lapply}.
If you want the callbacks
to be called immediately after each loop, then set it to \code{1},
which is not optimal but the only way right now.}

\item{...}{passed to \code{\link[future]{plan}}}
}
\value{
same as
\code{with(FUN.args, lapply(x, function(el){eval(body(FUN))}))}
}
\description{
Apply, but in parallel
}
\details{
When \code{plan} is logical, \code{FALSE} means use current plan.
If \code{plan=TRUE}, then it equals to \code{plan='multicore'}. For
characters, \code{plan} can be \code{'multicore'}, \code{'callr'},
\code{'sequential'}, \code{'multisession'}, \code{'multiprocess'},
etc. Alternatively, you could pass future \code{\link[future]{plan}}
objects.
}
\examples{

library(future)
plan(sequential)

# Use sequential plan
# 1. Change `plan` to 'multicore', 'multisession', or TRUE to enable
# multi-core, but still with progress information
# 2. Change plan=FALSE will use current future plan
res <- lapply_async2(100:200, function(x){
  return(x+1)
}, callback = function(e){
  sprintf('Input=\%d', e)
}, plan = 'sequential')

# Disable callback message, then the function reduce to
# normal `future.apply::future_lapply`
res <- lapply_async2(100:200, function(x){
  return(x+1)
}, callback = NULL, plan = FALSE)


}
