% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{installTFpython}
\alias{installTFpython}
\title{Install Python dependencies for digitalDLSorteR}
\usage{
installTFpython(conda = "auto", install.conda = FALSE, miniconda.path = NULL)
}
\arguments{
\item{conda}{Path to a conda executable. Use \code{"auto"} (by default)
allows \pkg{reticulate} to automatically find an appropriate conda binary.}

\item{install.conda}{Boolean indicating if install miniconda automatically
using \pkg{reticulate}. If \code{TRUE}, \code{conda} argument is ignored.
\code{FALSE} by default.}

\item{miniconda.path}{If \code{install.conda} is \code{TRUE}, you can set the
path where miniconda will be installed. If \code{NULL}, conda will find
automatically the proper place.}
}
\value{
No return value, called for side effects: installation of conda
environment with a Python interpreter and Tensorflow
}
\description{
This is a helper function to install Python dependencies needed: a Python
interpreter with TensorFlow Python library and its dependencies. It is
performed using the \pkg{reticulate} package and the installer of the
\pkg{tensorflow} R package. The available options are virtual or conda
environments. The new environment is called digitaldlsorter-env. In any case,
this installation can be manually done as it is explained in
\url{https://diegommcc.github.io/digitalDLSorteR/articles/kerasIssues.html},
but we recommend using this function.
}
\details{
This function is intended to make easier the installation of the requirements
needed to use \pkg{digitalDLSorteR}. It will automatically install Miniconda
(if wanted, see Parameters) and create an environment called
'digitaldlsorter-env'. If you want to use other python/conda environment, see
\code{?tensorflow::use_condaenv} and/or the vignettes.
}
\examples{
\dontrun{
notesInstallation <- installTFpython(
  method = "auto", conda = "auto", install.conda = TRUE
)
}

}
