% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/difNLR.R
\name{predict.difNLR}
\alias{predict.difNLR}
\title{Predicted values for difNLR object}
\usage{
\method{predict}{difNLR}(object, item = "all", match, group, ...)
}
\arguments{
\item{object}{an object of "difNLR" class}

\item{item}{either character (\code{"all"}), or numeric vector, or single number
corresponding to column indicators.}

\item{match}{numeric: specifies matching criterion for new observation. See \strong{Details}.}

\item{group}{numeric: specifies group membership for new observation. See \strong{Details}.}

\item{...}{other generic parameters for \code{predict()} function.}
}
\description{
Predicted values based on "difNLR" object.
}
\details{
Arguments \code{match} and \code{group} represent matching criterion and
group membership of new observations and need to have the same length.
}
\examples{
\dontrun{
# loading data based on GMAT
data(GMAT)

Data  <- GMAT[, 1:20]
group <- GMAT[, "group"]

# Testing both DIF effects using likelihood-ratio test and
# 3PL model with fixed guessing for groups
(x <- difNLR(Data, group, focal.name = 1, model = "3PLcg"))

# Predicted values
predict(x)
predict(x, item = 1)

# Predicted values for new observations
predict(x, item = 1, match = 0, group = 1)
predict(x, item = 1, match = 0, group = 0)
}
}
\references{
Drabinova, A. & Martinkova P. (2017). Detection of Differential Item Functioning with NonLinear Regression:
Non-IRT Approach Accounting for Guessing. Journal of Educational Measurement, 54(4), 498-517.

Swaminathan, H. & Rogers, H. J. (1990). Detecting Differential Item Functioning Using Logistic Regression Procedures.
Journal of Educational Measurement, 27, 361-370.
}
\seealso{
\code{\link[difNLR]{difNLR}}
}
\author{
Adela Drabinova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
Faculty of Mathematics and Physics, Charles University \cr
drabinova@cs.cas.cz \cr

Patricia Martinkova \cr
Institute of Computer Science, The Czech Academy of Sciences \cr
martinkova@cs.cas.cz \cr

Karel Zvara \cr
Faculty of Mathematics and Physics, Charles University \cr
}
