% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/objects.R
\name{create_SCE}
\alias{create_SCE}
\title{Create an SCE object from a sparse matrix}
\usage{
create_SCE(x, name = "SCE")
}
\arguments{
\item{x}{A sparse matrix consisting of raw expression counts from a 
single-cell RNA experiment, with genes in the rows and 
droplets in the columns.}

\item{name}{An optional character name for the SCE object.}
}
\value{
SCE object
}
\description{
Create an SCE object from a sparse matrix
}
\examples{
counts <- matrix(sample(c(0,1,2), 1000, replace=TRUE),  nrow=10, ncol=100)
mb_sce <- create_SCE(x=counts, name="Mouse Brain")
}
