% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/animations.R
\name{animate_topo_mean}
\alias{animate_topo_mean}
\title{Animate EEG average topographic map with confidence bounds}
\usage{
animate_topo_mean(
  data,
  t_lim,
  FS = 250,
  t0 = 1,
  mesh,
  coords = NULL,
  template = NULL,
  col_range = NULL,
  col_scale = NULL,
  show_legend = TRUE,
  contour = FALSE,
  output_path = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame, tibble or a database table with input data to plot. It should be an output from \code{\link{compute_mean}} function or an object with the same structure, containing columns: \code{sensor} with sensor labels and \code{average, ci_low, ci_up} with values of average signal and lower and upper CI bounds.}

\item{t_lim}{Limits of time points (i.e., the length of the timeline displayed below the animation).}

\item{FS}{The sampling frequency. Default value is 250 Hz.}

\item{t0}{Index of the zero time point, i.e. point, where 0 ms should be marked (most often time of the stimulus or time of the response).}

\item{mesh}{A \code{"mesh"} object (or a named list with the same structure) containing at least \code{D2} element with x and y coordinates of a point mesh used for computing IM model. If not defined, the point mesh with default settings from \code{\link{point_mesh}} function is used.}

\item{coords}{Sensor coordinates as a tibble or data frame with named \code{x}, \code{y} columns of sensor coordinates and \code{sensor} column with sensor names. If not defined, the HCGSN256 template is used.}

\item{template}{The kind of sensor template montage used. Currently the only available option is \code{"HCGSN256"} denoting the 256-channel HydroCel Geodesic Sensor Net v.1.0, which is also a default setting.}

\item{col_range}{A vector with minimum and maximum value of the amplitude used in the colour palette for plotting. If not defined, the range of the input signal is used.}

\item{col_scale}{Optionally, a colour scale to be utilised for plotting. If not defined, it is computed from \code{col_range}.}

\item{show_legend}{Logical. Indicates, whether legend should be displayed below the graph. Default value is \code{TRUE}.}

\item{contour}{Logical. Indicates, whether contours should be plotted in the graph. Default value is \code{FALSE}.}

\item{output_path}{File path where the animation will be saved using \code{gifski} renderer (optional). If not defined, the animation is plotted in the RStudio Viewer.}

\item{...}{Additional parameters for animation according to \link[gganimate:animate]{gganimate::animate}.}
}
\value{
If \code{output_path} is \code{NULL}, the function prints the animation to the RStudio Viewer.
If \code{output_path} is specified, the animation is saved to the given file path and not displayed. The \code{gifski} and \code{magick} packages are required for animation export.
}
\description{
An animation of the average signal time course as a topographic map along with the lower and upper bounds of the confidence interval. In the output, three facets are plotted per frame: CI lower, average, CI upper.
}
\details{
Note: When specifying the \code{coords} and \code{template} at the same time, the \code{template} parameter takes precedence and the \code{coords} parameter is ignored.
}
\examples{
\donttest{
# This example may take a few seconds to render.
# Run only if you want to generate the full animation.

# a) prepare data: compute the mean from baseline corrected signal for subject 2,
# first 10 points and only 13 epochs (epochs 14 and 15 are outliers)
edata <- epochdata |>
dplyr::filter(subject == 2 & time \%in\% 1:10 & epoch \%in\% 1:13)
data_base <- baseline_correction(edata, baseline_range = 1:10) # baseline correction
data_mean <- compute_mean(data_base, amplitude = "signal_base", subject = 2,
 type = "jack", group = "space") # compute mean
# b) render the animation
# (t0 = 10 because the time of the stimulus in epochdata is in time point 10)
animate_topo_mean(data_mean, t_lim = c(1,50), t0 = 10)
}
}
\seealso{
\code{\link{animate_topo}}, \code{\link{compute_mean}}, \code{\link{baseline_correction}}
}
