% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{create_custom_domino_legends}
\alias{create_custom_domino_legends}
\title{Create custom legends for a domino plot}
\usage{
create_custom_domino_legends(
  contrast_levels,
  var_positions,
  var_id,
  contrast,
  logfc_colors,
  logfc_limits,
  color_scale_name,
  size_scale_name,
  min_dot_size,
  max_dot_size,
  size_limits = NULL,
  size_breaks = NULL,
  legend_text_size = 8,
  p_label_formatter = function(lp) sprintf("\%.2g", 10^-lp)
)
}
\arguments{
\item{contrast_levels}{Character vector of contrast level names.}

\item{var_positions}{Data frame with variable positions.}

\item{var_id}{Column name for the variable identifier.}

\item{contrast}{Column name for the contrast variable.}

\item{logfc_colors}{Named vector with "low", "mid", "high" colours.}

\item{logfc_limits}{Numeric vector (length 2) for logFC scale limits.}

\item{color_scale_name}{Title for the logFC colour legend.}

\item{size_scale_name}{Title for the p-value size legend.}

\item{min_dot_size, max_dot_size}{Numeric dot-size range.}

\item{size_limits, size_breaks}{Passed to \code{scale_size_continuous()}.}

\item{legend_text_size}{Base font size for legend text.}

\item{p_label_formatter}{A function used to format the size legend labels (typically for p-values). Default is \code{function(lp) sprintf("\%.2g", 10^-lp)}.}
}
\value{
A combined \code{ggplot} object with three aligned legends.
}
\description{
Create custom legends for a domino plot
}
\keyword{internal}
