% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sigclust.R
\name{sigclust}
\alias{sigclust}
\title{Significant Testing of Clustering Results}
\usage{
sigclust(x, k, nsim, nrep = 1, labflag = 0, label = 0, icovest = 2)
}
\arguments{
\item{x}{data matrix, samples are rows and features are columns}

\item{k}{cluster size to test against}

\item{nsim}{number of simulations}

\item{nrep}{See \code{\link[sigclust]{sigclust}} for details.}

\item{labflag}{See \code{\link[sigclust]{sigclust}} for details.}

\item{label}{true class label. See \code{\link[sigclust]{sigclust}} for
details.}

\item{icovest}{type of covariance matrix estimation}
}
\value{
An object of class \code{sigclust}. See
  \code{\link[sigclust]{sigclust}} for details.
}
\description{
Uses the SigClust K-Means algorithm to assess significance of clustering
results.
}
\details{
This function is a wrapper for the original \code{\link[sigclust]{sigclust}},
except that an additional parameter \code{k} is allows testing against any
number of clusters. In addition, the default type of covariance estimation is
also different.
}
\examples{
data(hgsc)
dat <- hgsc[1:100, 1:50]
nk <- 4
cc <- consensus_cluster(dat, nk = nk, reps = 5, algorithms = "pam",
progress = FALSE)
cl.mat <- consensus_combine(cc, element = "class")
lab <- cl.mat$`4`[, 1]
set.seed(1)
str(sigclust(x = dat, k = nk, nsim = 50, labflag = 1, label = lab))
}
\references{
Liu, Yufeng, Hayes, David Neil, Nobel, Andrew and Marron, J. S,
  2008, \emph{Statistical Significance of Clustering for High-Dimension,
  Low-Sample Size Data}, \emph{Journal of the American Statistical
  Association} \bold{103}(483) 1281--1293.
}
\author{
Hanwen Huang: \email{hanwenh@email.unc.edu}; Yufeng Liu:
  \email{yfliu@email.unc.edu}; J. S. Marron: \email{marron@email.unc.edu}
}
