% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weight_plot.R
\name{weight_plot}
\alias{weight_plot}
\title{Diagnostic plot of importance sampling weights}
\usage{
weight_plot(w)
}
\arguments{
\item{w}{Vector of weights}
}
\description{
Function \code{weight_plot} plots four figures given the weight vector \code{w}: 
Plot of largest weights, sorted graph of all weights, running variance estimate of weights, 
and running effective sample size estimate of weights.
}
\examples{
#' importance sampling from too narrow distribution
#' weights have infinite variance
set.seed(1)
x_inf <- rnorm(1000, sd = 0.1)
w_inf <- dnorm(x_inf) / dnorm(x_inf, 0, 0.1)
weight_plot(w_inf)
x_opt <- rnorm(1000, sd = sqrt(2))
w_opt <- dnorm(x_opt) / dnorm(x_opt, 0, sqrt(2))
weight_plot(w_opt)
}
