% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/validation.R
\name{validate}
\alias{validate}
\alias{validate.gp}
\alias{validate.dgp}
\alias{validate.lgp}
\title{Validate a constructed GP, DGP, or linked (D)GP emulator}
\usage{
validate(object, x_test, y_test, method, verb, force, cores, ...)

\method{validate}{gp}(
  object,
  x_test = NULL,
  y_test = NULL,
  method = "mean_var",
  verb = TRUE,
  force = FALSE,
  cores = 1,
  ...
)

\method{validate}{dgp}(
  object,
  x_test = NULL,
  y_test = NULL,
  method = "mean_var",
  verb = TRUE,
  force = FALSE,
  cores = 1,
  threading = FALSE,
  ...
)

\method{validate}{lgp}(
  object,
  x_test = NULL,
  y_test = NULL,
  method = "mean_var",
  verb = TRUE,
  force = FALSE,
  cores = 1,
  threading = FALSE,
  ...
)
}
\arguments{
\item{object}{can be one of the following:
\itemize{
\item the S3 class \code{gp}.
\item the S3 class \code{dgp}.
\item the S3 class \code{lgp}.
}}

\item{x_test}{the OOS testing input data:
\itemize{
\item if \code{x} is an instance of the \code{gp} or \code{dgp} class, \code{x_test} is a matrix where each row is an input testing data point and each column is an input dimension.
\item if \code{x} is an instance of the \code{lgp} class, \code{x_test} can be a matrix or a list:
\itemize{
\item if \code{x_test} is a matrix, it is the global testing input data that feed into the emulators in the first layer of a system.
The rows of \code{x_test} represent different input data points and the columns represent input dimensions across all emulators in
the first layer of the system. In this case, it is assumed that the only global input to the system is the input to the
emulators in the first layer and there is no global input to emulators in other layers.
\item if \code{x_test} is a list, it should have \emph{L} (the number of layers in an emulator system) elements. The first element
is a matrix that represents the global testing input data that feed into the emulators in the first layer of the system. The
remaining \emph{L-1} elements are \emph{L-1} sub-lists, each of which contains a number (the same number of emulators in
the corresponding layer) of matrices (rows being testing input data points and columns being input dimensions) that represent the
global testing input data to the emulators in the corresponding layer. The matrices must be placed in the sub-lists based on how
their corresponding emulators are placed in \code{struc} argument of \code{\link[=lgp]{lgp()}}. If there is no global input data to a certain emulator,
set \code{NULL} in the corresponding sub-list of \code{x_test}.
}
}

\code{x_test} must be provided for the validation if \code{x} is an instance of the \code{lgp}. Defaults to \code{NULL}.}

\item{y_test}{the OOS testing output data that correspond to \code{x_test}:
\itemize{
\item if \code{x} is an instance of the \code{gp} class, \code{y_test} is a matrix with only one column and each row being an testing output data point.
\item if \code{x} is an instance of the \code{dgp} class, \code{y_test} is a matrix with its rows being testing output data points and columns being
output dimensions.
\item if \code{x} is an instance of the \code{lgp} class, \code{y_test} can be a single matrix or a list of matrices:
\itemize{
\item if \code{y_test} is a single matrix, then there is only one emulator in the final layer of the linked emulator system and \code{y_test}
represents the emulator's output with rows being testing positions and columns being output dimensions.
\item if \code{y_test} is a list, then \code{y_test} should have \emph{M} number (the same number of emulators in the final layer of the system) of matrices.
Each matrix has its rows corresponding to testing positions and columns corresponding to output dimensions of the associated emulator
in the final layer.
}
}

\code{y_test} must be provided for the validation if \code{x} is an instance of the \code{lgp}. Defaults to \code{NULL}.}

\item{method}{the prediction approach in validations: mean-variance (\code{"mean_var"}) or sampling (\code{"sampling"}) approach. Defaults to \code{"mean_var"}.}

\item{verb}{a bool indicating if the trace information on validations will be printed during the function execution.
Defaults to \code{TRUE}.}

\item{force}{a bool indicating whether to force the LOO or OOS re-evaluation when \code{loo} or \code{oos} slot already exists in \code{object}. When \code{force = FALSE},
\code{\link[=validate]{validate()}} will try to determine automatically if the LOO or OOS re-evaluation is needed. Set \code{force} to \code{TRUE} when LOO or OOS re-evaluation
is required. Defaults to \code{FALSE}.}

\item{cores}{the number of cores/workers to be used for the LOO or OOS validation. If set to \code{NULL},
the number of cores is set to \verb{(max physical cores available - 1)}. Defaults to \code{1}.}

\item{...}{N/A.}

\item{threading}{a bool indicating whether to use the multi-threading to accelerate the LOO or OOS.
Turning this option on could improve the speed of validations when the emulator is built with a moderately large number of
training data points and the Matérn-2.5 kernel.}
}
\value{
\itemize{
\item If \code{object} is an instance of the \code{gp} class, an updated \code{object} is returned with an additional slot called \code{loo} (for LOO cross validation) or
\code{oos} (for OOS validation) that contains:
\itemize{
\item two slots called \code{x_train} (or \code{x_test}) and \code{y_train} (or \code{y_test}) that contain the validation data points for LOO (or OOS).
\item a column matrix called \code{mean}, if \code{method = "mean_var"}, or \code{median}, if \code{method = "sampling"}, that contains the predictive means or medians of the
GP emulator at validation positions.
\item three column matrices called \code{std}, \code{lower}, and \code{upper} that contain the predictive standard deviations and credible intervals of the
GP emulator at validation positions. If \code{method = "mean_var"}, the upper and lower bounds of a credible interval are two standard deviations above
and below the predictive mean. If \code{method = "sampling"}, the upper and lower bounds of a credible interval are 2.5th and 97.5th percentiles.
\item a numeric value called \code{rmse} that contains the root mean/median squared error of the GP emulator.
\item a numeric value called \code{nrmse} that contains the (min-max) normalized root mean/median squared error of the GP emulator. The min-max normalization
is based on the maximum and minimum values of the validation outputs contained in \code{y_train} (or \code{y_test}).
}

The rows of matrices (\code{mean}, \code{median}, \code{std}, \code{lower}, and \code{upper}) correspond to the validation positions.
\item If \code{object} is an instance of the \code{dgp} class, an updated \code{object} is returned with an additional slot called \code{loo} (for LOO cross validation) or
\code{oos} (for OOS validation) that contains:
\itemize{
\item two slots called \code{x_train} (or \code{x_test}) and \code{y_train} (or \code{y_test}) that contain the validation data points for LOO (or OOS).
\item a matrix called \code{mean}, if \code{method = "mean_var"}, or \code{median}, if \code{method = "sampling"}, that contains the predictive means or medians of the
DGP emulator at validation positions.
\item three matrices called \code{std}, \code{lower}, and \code{upper} that contain the predictive standard deviations and credible intervals of the
DGP emulator at validation positions. If \code{method = "mean_var"}, the upper and lower bounds of a credible interval are two standard deviations above
and below the predictive mean. If \code{method = "sampling"}, the upper and lower bounds of a credible interval are 2.5th and 97.5th percentiles.
\item a vector called \code{rmse} that contains the root mean/median squared errors of the DGP emulator across different output
dimensions.
\item a vector called \code{nrmse} that contains the (min-max) normalized root mean/median squared errors of the DGP emulator across different output
dimensions. The min-max normalization is based on the maximum and minimum values of the validation outputs contained in \code{y_train} (or \code{y_test}).
}

The rows and columns of matrices (\code{mean}, \code{median}, \code{std}, \code{lower}, and \code{upper}) correspond to the validation positions and DGP emulator output
dimensions, respectively.
\item If \code{object} is an instance of the \code{lgp} class, an updated \code{object} is returned with an additional slot called \code{oos} (for OOS validation) that contains:
\itemize{
\item two slots called \code{x_test} and \code{y_test} that contain the validation data points for OOS.
\item a list called \code{mean}, if \code{method = "mean_var"}, or \code{median}, if \code{method = "sampling"}, that contains the predictive means or medians of
the linked (D)GP emulator at validation positions.
\item three lists called \code{std}, \code{lower}, and \code{upper} that contain the predictive standard deviations and credible intervals of
the linked (D)GP emulator at validation positions. If \code{method = "mean_var"}, the upper and lower bounds of a credible interval are two standard
deviations above and below the predictive mean. If \code{method = "sampling"}, the upper and lower bounds of a credible interval are 2.5th and 97.5th percentiles.
\item a list called \code{rmse} that contains the root mean/median squared errors of the linked (D)GP emulator.
\item a list called \code{nrmse} that contains the (min-max) normalized root mean/median squared errors of the linked (D)GP emulator. The min-max normalization
is based on the maximum and minimum values of the validation outputs contained in \code{y_test}.
}

Each element in \code{mean}, \code{median}, \code{std}, \code{lower}, \code{upper}, \code{rmse}, and \code{nrmse} corresponds to a (D)GP emulator in the final layer of the linked (D)GP
emulator.
}
}
\description{
This function validate a constructed GP, DGP, or linked (D)GP emulator via the Leave-One-Out (LOO)
cross validation or Out-Of-Sample (OOS) validation.
}
\details{
See further examples and tutorials at \url{https://mingdeyu.github.io/dgpsi-R/}.
}
\note{
\itemize{
\item When both \code{x_test} and \code{y_test} are \code{NULL}, the LOO cross validation will be implemented. Otherwise, OOS validation will
be implemented. The LOO validation is only applicable to a GP or DGP emulator (i.e., \code{x} is an instance of the \code{gp} or \code{dgp}
class). If a linked (D)GP emulator (i.e., \code{x} is an instance of the \code{lgp} class) is provided, \code{x_test} and \code{y_test} must
also be provided for OOS validation.
\item Any R vector detected in \code{x_test} and \code{y_test} will be treated as a column vector and automatically converted into a single-column
R matrix. Thus, if \code{x_test} or \code{y_test} is a single testing data point with multiple dimensions, it must be given as a matrix.
}
}
\examples{
\dontrun{

# See gp(), dgp(), or lgp() for an example.
}
}
