% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{plot_outbreak}
\alias{plot_outbreak}
\title{Produce a stacked plot to present composited, site-level insect outbreak
chronologies}
\usage{
plot_outbreak(x, disp_index = c("GSI", "NGSI"))
}
\arguments{
\item{x}{an 'obr' object produced by \code{\link[=outbreak]{outbreak()}}}

\item{disp_index}{Identify the timeseries index to plot. Defaults to
\code{NGSI}, the average normalized growth suppression index for the
site. The only other option is \code{GSI}, the average growth
suppression index.}
}
\description{
Produce a stacked plot to present composited, site-level insect outbreak
chronologies
}
\examples{
data(dmj_obr)
plot_outbreak(dmj_obr)

# Change middle panel display from the default "NGSI" to "GSI"
plot_outbreak(dmj_obr, disp_index = "GSI")

}
