\name{glimem}
\alias{glimem}

\title{
The logistic regression mixed effect model. 
}

\description{
This function corresponds to the generalized logistic regression mixed effect model. This model is a model-based method for combining toxicities across the trials and cycles. We model:
\deqn{log(\frac{R_{ij}(x)}{1 - R_{ij}(x)}) = \mu_{ij}(x) + Z_i,}
where \eqn{Z_{i}}'s are assumed to be i.i.d \eqn{\mathcal{N}(0, \sigma^{2}(x))}. Notice that \eqn{\mu_{i1}(x), \mu_{i2}(x),..., \mu_{iP}(x) = \bar{\mu}_i} represents the mean toxicities on the logit scale across the cycles.
}

\usage{
glimem(simData, sim0, sim1, family = binomial, link = "logit", nAGQ, 
  control = glmerControl(optimizer = "bobyqa"))
}

\arguments{
  \item{simData}{
a data frame containing the variables named in the formula (i.e. a toxicity data for each patient at each simulation and trial.
}
  \item{sim0}{
the simulation starting point; defaults to the minimum number of the simulation in the given data frame.
}
  \item{sim1}{
the simulation ending point; defaults to the maximum number of the simulation in the given data frame.
}
  \item{family}{
a distribution family for the response variable; defaults to binomial distribution. See \code{\link{glm}} and \code{\link{glmer}} for details.
}
  \item{link}{
a specification for the model link function. This can be a name/expression, a literal character string or a length-one character vector; defaults to logit link function. See \code{\link{glmer}} for details.
}
  \item{nAGQ}{
an integer scalar - the number of points per axis for evaluating the adaptive Gauss-Hermite approximation to the log-likelihood; defaults to 1, corresponding to the Laplace approximation. Values greater than 1 produce greater accuracy in the evaluation of the log-likelihood at the expense of speed. 
}
  \item{control}{
a list (of correct class, resulting from \code{\link{lmerControl}}() or \code{\link{glmerControl}}() respectively) containing control parameters, including the nonlinear optimizer to be used and parameters to be passed through to the nonlinear optimizer, see the *lmerControl* documentation for details.
}
}

\value{A list is returned, consisting of the generalized logistic regression mixed effect model's results. The output generated by this function contains the following components: 
\item{m}{a summary of the generalized logistic regression model.}
\item{coeff}{the random and the fixed effects coefficients for each explanatory variable for each level of each grouping factor.}
\item{simData}{a data frame including the predicted values and the residuals for the selected simulation.}
}

\author{
Artemis Toumazi <artemis.toumazi@gmail.com>, Sarah Zohar <sarah.zohar@inserm.fr>, Anand N. Vidyashankar <avidyash@gmu.edu>, Jie Xu <jxu13@gmu.edu> and Moreno Ursino <moreno.ursino@inserm.fr>
}

\seealso{
\code{\link{MA_estimates}}
}

\examples{
  \dontrun{
    ################################################################
    ### Give a toxicity data for each simulation and each trial. ###
    ################################################################
    
    ### Using a toxicity data for each simulation and each trial including in the dfmeta package.
    data("Toxdata")
    dim(Toxdata)
    colnames(Toxdata)
    
    ## NOTE: The toxicity dataset must have the same structure as below. ##
    ## Check it before running the VarWT function! ##
    str(Toxdata)
    
    analyf0 <- Toxdata[order(Toxdata$simulation), ]
    
    ## Using the random effect analysis's function including in the dfmeta package ##
    simData <- doseRecords(analyf0)
    NewData <- simData$doseRecords
    
    ########################################################################################
    ## In the following example the function glimem is using to find the predicted random ##  
    ###################### effect center mu only for the simulation 10 #####################
    ########################################################################################
    
    mod <- glimem(NewData, 10, 10, family = binomial, link = "logit", nAGQ = 1, 
                  control = glmerControl(optimizer = "bobyqa"))
    mod
  }
}
