#' dfidx package: linear models for panel data
#' 
#' plm is a package for R which intends to make the estimation of linear panel
#' models straightforward. plm provides functions to estimate a wide variety of
#' models and to make (robust) inference.
#' 
#' For a gentle and comprehensive introduction to the package, please see the
#' package's vignette.
#' 
#' The main functions to estimate models are:
#'
#' - `plm` : panel data estimators using `lm` on transformed data,
#' -`pgmm` generalized method of moments (GMM) estimation for panel
#' data,
#' - `pvcm` variable coefficients models
#' - `pmg` mean groups (MG), demeaned MG and common correlated effects
#' (CCEMG) estimators.
#'
#' Next to the model estimation functions, the package offers several
#' functions for statistical tests related to panel data/models.
#' 
#' Multiple functions for (robust) variance--covariance matrices are
#' at hand as well.
#' 
#' The package also provides data sets to demonstrate functions and to
#' replicate some text book/paper results.  Use
#' `data(package="plm")` to view a list of available data sets in
#' the package.
#' 
#' @name dfidx-package
#' @docType package
#' @keywords package

