% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interaction_model.R
\name{fit_domains}
\alias{fit_domains}
\title{Estimate the Rasch and the Interaction model per domain}
\usage{
fit_domains(dataSrc, item_property, predicate = NULL)
}
\arguments{
\item{dataSrc}{Data source: a dexter project db handle or a data.frame with columns: person_id, item_id, item_score}

\item{item_property}{The item property defining the
domains (subtests)}

\item{predicate}{An optional expression to subset data, if NULL all data is used}
}
\value{
An object of class \code{imp} holding results
for the Rasch model and the interaction model.
}
\description{
Estimate the parameters of the Rasch model and the Interaction model
}
\details{
We have generalised the interaction model for items having more than two (potentially, a largish number) 
of response categories. This function represents scores on subtests as 
super-items and analyses these as normal items.
}
\examples{
\dontrun{
db = start_new_project(verbAggrRules, "verbAggression.db")
add_booklet(db, verbAggrData, "agg")
add_item_properties(db, verbAggrProperties)
mSit = fit_domains(db, item_property= "situation")
plot(mSit)

close_project(db)
}

}
\seealso{
\code{\link{plot.rim}}, \code{\link{fit_inter}}, \code{\link{add_item_properties}}
}
